(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Int.m3                                                *)
(* Last Modified On Mon Mar  2 10:32:52 PST 1992 by kalsow     *)
(*      Modified On Fri Dec 21 01:48:33 1990 by muller         *)

MODULE Int;

IMPORT Type, Target, Tipe, Emit, MBuf, TypeRep;

TYPE
  P = Type.T BRANDED "Int.T" OBJECT
      OVERRIDES
      (*check      := ALREADY DONE *)
        base       := TypeRep.SelfBase;
        isEqual    := TypeRep.NeverEqual;
        isSubtype  := TypeRep.NoSubtypes;
        count      := Counter;
        bounds     := Bounder; 
        size       := Sizer;
        minSize    := Sizer;
        alignment  := Aligner;
	isEmpty    := TypeRep.IsNever;
        dependsOn  := TypeRep.DependsOnNone;
        compile    := Compiler;
        initCost   := InitCoster;
        initValue  := GenInit;
        mapper     := TypeRep.NoMapper;
        fprint     := FPrinter;
        class      := MyClass;
      END;

PROCEDURE MyClass (<*UNUSED*> t: Type.T): TypeRep.Class =
  BEGIN
    RETURN TypeRep.Class.None;
  END MyClass;

PROCEDURE Compiler (t: Type.T) =
  BEGIN
    Emit.OpF ("\003#define @ _INTEGER\n", t);
    IF TypeRep.StartLinkInfo (t) THEN RETURN END;
    Emit.Op  ("C\n");
    Emit.OpF ("\003#define @ _INTEGER\n", t);
    Emit.Op  ("*\n");
  END Compiler;

PROCEDURE Counter (<*UNUSED*> t: Type.T): INTEGER =
  BEGIN
    (* BUG *)
    RETURN Target.MAXINT(* - Target.MININT *);
  END Counter;

PROCEDURE Bounder (<*UNUSED*> t: Type.T; VAR min, max: INTEGER): BOOLEAN =
  BEGIN
    min := Target.MININT;
    max := Target.MAXINT;
    RETURN TRUE;
  END Bounder;

PROCEDURE Sizer (<*UNUSED*> t: Type.T): INTEGER =
  BEGIN
    RETURN Target.INTSIZE;
  END Sizer;

PROCEDURE Aligner (<*UNUSED*> t: Type.T): INTEGER =
  BEGIN
    RETURN Target.INTALIGN;
  END Aligner;

PROCEDURE InitCoster (<*UNUSED*> t: Type.T; 
                      <*UNUSED*> zeroed: BOOLEAN): INTEGER =
  BEGIN
    RETURN 0;
  END InitCoster;

PROCEDURE GenInit (<*UNUSED*> t: Type.T) =
  BEGIN
    Emit.Op ("0");
  END GenInit;

PROCEDURE FPrinter (<*UNUSED*>t: Type.T; <*UNUSED*>map: Type.FPMap; wr: MBuf.T) =
  BEGIN
    MBuf.PutText (wr, "$integer");
  END FPrinter;

PROCEDURE Initialize () =
  BEGIN
    T := NEW (P);
    TypeRep.Init (T);
    T.checked := TRUE;
    T.hash := 5;
    Tipe.Define ("INTEGER", T, TRUE);
  END Initialize;

BEGIN
END Int.
