(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Void.m3                                               *)
(* Last Modified On Mon Mar  2 10:36:25 PST 1992 by kalsow     *)
(*      Modified On Thu Dec  5 17:24:02 PST 1991 by muller     *)

MODULE Void;

IMPORT Type, TypeRep, Emit, Tipe, MBuf;

TYPE
  P = Type.T BRANDED "Void.T" OBJECT
      OVERRIDES
      (*check      := ALREADY DONE *)
        base       := TypeRep.SelfBase;
        isEqual    := TypeRep.NeverEqual;
        isSubtype  := TypeRep.NoSubtypes;
        count      := TypeRep.NotOrdinal;
        bounds     := TypeRep.NotBounded; 
        size       := NoSize;
        minSize    := NoSize;
        alignment  := NoAlign;
	isEmpty    := TypeRep.IsAlways;
        dependsOn  := TypeRep.DependsOnNone;
        compile    := Compiler;
        initCost   := InitCoster;
        initValue  := GenInit;
        mapper     := TypeRep.NoMapper;
        fprint     := FPrinter;
        class      := MyClass;
      END;

PROCEDURE MyClass (<*UNUSED*> t: Type.T): TypeRep.Class =
  BEGIN
    RETURN TypeRep.Class.None;
  END MyClass;

PROCEDURE NoSize (<*UNUSED*> t: Type.T): INTEGER =
  BEGIN
    RETURN 0;
  END NoSize;

PROCEDURE NoAlign (<*UNUSED*> t: Type.T): INTEGER =
  BEGIN
    RETURN 1;
  END NoAlign;

PROCEDURE Compiler (t: Type.T) =
  BEGIN
    Emit.OpF ("\003#define @ _VOID\n", t);
    IF TypeRep.StartLinkInfo (t) THEN RETURN END;
    Emit.Op  ("C\n");
    Emit.OpF ("\003#define @ _VOID\n", t);
    Emit.Op  ("*\n");
  END Compiler;

PROCEDURE InitCoster (<*UNUSED*> t: Type.T; 
                      <*UNUSED*> zeroed: BOOLEAN): INTEGER =
  BEGIN
    RETURN 0;
  END InitCoster;

PROCEDURE GenInit (<*UNUSED*> t: Type.T) =
  BEGIN
    <* ASSERT FALSE *>
  END GenInit;

PROCEDURE FPrinter (<*UNUSED*>t: Type.T; <*UNUSED*>map: Type.FPMap; wr: MBuf.T) =
  BEGIN
    MBuf.PutText (wr, "$void");
  END FPrinter;

PROCEDURE Initialize () =
  BEGIN
    T := NEW (P);
    TypeRep.Init (T);
    T.checked := TRUE;
    T.hash := -1;
    Tipe.Define ("_VOID", T, FALSE);
  END Initialize;

BEGIN
END Void.
