(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: M3.i3                                                 *)
(* Last modified on Thu Feb 13 09:50:57 PST 1992 by kalsow         *)
(*      modified on Wed Nov 21 01:28:24 1990 by muller         *)


INTERFACE M3;

(* This interface defines some base object types so that circular
   dependencies between other interfaces may be avoided. *)

TYPE
  Flag  = BITS 1 FOR BOOLEAN;
  Node  = UNTRACED OBJECT origin: INTEGER END;
  Scope <: Node;    (* == Scope.T *)
  Value <: Node;    (* == Value.T *)
  Expr  <: Node;    (* == Expr.T  *)
  Stmt  <: Node;    (* == Stmt.T  *)
  Type  <: Node;    (* == Type.T  *)
  Temp  <: ADDRESS; (* == Temp.T  *)
  ExSet <: Node;    (* == ESet.T  *)

VAR NextLabel: INTEGER := 0; (* for the generated "_L" labels *)

TYPE (* the "global state" that is passed around during type checking *)
  CheckState = RECORD
    raises_others : BOOLEAN;
    ok_to_raise   : ExSet;
    no_error      : ExSet;
  END;

CONST
  OuterCheckState = CheckState {
    raises_others := FALSE,
    ok_to_raise   := NIL,
    no_error      := NIL
  };

END M3.
