(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: EvalStmt.m3                                           *)
(* Last modified on Wed Apr 15 13:17:45 PDT 1992 by kalsow     *)
(*      modified on Tue Apr 10 22:53:33 1990 by muller         *)

MODULE EvalStmt;

IMPORT Expr, Token, Scanner, Stmt, StmtRep, Error, Temp, Void, Type, Emit;

TYPE
  P = Stmt.T OBJECT
        e       : Expr.T;
      OVERRIDES
        check    := Check;
	compile  := Compile;
        outcomes := GetOutcome;
      END;

PROCEDURE Parse (READONLY fail: Token.Set): Stmt.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    StmtRep.Init (p);
    Scanner.Match (Token.T.tEVAL, fail, Token.ExprStart);
    p.e := Expr.Parse (fail);
    RETURN p;
  END Parse;

PROCEDURE Check (p: P;  VAR cs: Stmt.CheckState) =
  BEGIN
    Expr.TypeCheck (p.e, cs);
    IF Type.IsEqual (Expr.TypeOf (p.e), Void.T, NIL) THEN
      Error.Msg ("expression doesn\'t have a value");
    END;
  END Check;

PROCEDURE Compile (p: P): Stmt.Outcomes =
  VAR t: Temp.T;
  BEGIN
    t := Expr.Compile (p.e);
    Emit.OpT ("@;\n", t);
    Temp.Free (t);
    RETURN Stmt.Outcomes {Stmt.Outcome.FallThrough};
  END Compile;

PROCEDURE GetOutcome (<*UNUSED*> p: P): Stmt.Outcomes =
  BEGIN
    RETURN Stmt.Outcomes {Stmt.Outcome.FallThrough};
  END GetOutcome;

BEGIN
END EvalStmt.
