(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: ObjectType.i3                                         *)
(* Last Modified On Mon Nov 11 16:33:46 PST 1991 By kalsow         *)
(*      Modified On Fri Oct  5 07:29:44 1990 By muller         *)


INTERFACE ObjectType;

IMPORT Type, String, Scope, Token, Value, Expr;

PROCEDURE Parse (sup: Type.T;  traced: BOOLEAN;  brand: Expr.T;
                                             READONLY fail: Token.Set): Type.T;

PROCEDURE New (super: Type.T;  traced: BOOLEAN;  brand: Expr.T;
                                             fields, methods: Scope.T): Type.T;

PROCEDURE Is (t: Type.T): BOOLEAN;

PROCEDURE IsBranded (t: Type.T): BOOLEAN;

PROCEDURE LookUp (t: Type.T;  id: String.T;
                      VAR value: Value.T;  VAR visible: Type.T): BOOLEAN;

PROCEDURE MethodOffset (t: Type.T): INTEGER;
(* Returns the bit offset of the methods defined in object type t if
   all of its parents are visible, otherwise returns -1 *)

PROCEDURE FieldOffset (t: Type.T): INTEGER;
(* Returns the bit offset of the fields defined in object type t if
   all of its parents are visible, otherwise returns -1 *)

PROCEDURE FieldSize (t: Type.T): INTEGER;
(* Returns the bit size of the fields defined in object type t if
   all of its parents are visible, otherwise returns -1 *)

PROCEDURE Super (t: Type.T): Type.T;
(* Returns the super type of 't' if 't' is an object and it
   has been typechecked, otherwise NIL *)

END ObjectType.

