(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: ValueRep.i3                                           *)
(* Last modified on Thu Feb 13 09:03:41 PST 1992 by kalsow     *)
(*      modified on Fri Feb 23 03:41:40 1990 by muller         *)

INTERFACE ValueRep;

IMPORT MBuf, FPrint, M3, String, Type, Value;

REVEAL
  M3.Value = M3.Node BRANDED "Value.T" OBJECT
    name       : String.T;
    extName    : String.T;
    scope      : M3.Scope;
    next       : M3.Value;
    checkDepth : INTEGER;
    checked    : M3.Flag;
    readonly   : M3.Flag;
    declared   : M3.Flag;
    compiled   : M3.Flag;
    imported   : M3.Flag;
    exported   : M3.Flag;
    exportable : M3.Flag;
    external   : M3.Flag;
    used       : M3.Flag;
    unused     : M3.Flag;
    obsolete   : M3.Flag;
    inFrame    : M3.Flag;
    inTypeOf   : M3.Flag;
    inToExpr   : M3.Flag;
    inToType   : M3.Flag;
    error      : M3.Flag;
    fprint     : FPrint.T;
  METHODS
    typeCheck   (VAR cs: M3.CheckState);
    class       (): Value.Class;
    load        (): M3.Temp  := NoLoader;
    write       ()           := NoWriter;
    declare0    (): BOOLEAN  := Never;
    declare1    ()           := NoDeclarer;
    declare2    ()           := NoDeclarer;
    toExpr      (): M3.Expr  := NoExpr;
    toType      (): M3.Type  := NoType;
    typeOf      (): M3.Type  := NoType;
    base        (): M3.Value := Self;
    fingerprint (map: Type.FPMap;  wr: MBuf.T);
  END;

PROCEDURE Init (v: M3.Value;  name: String.T);
(* initializes a Value.T *)

PROCEDURE NoExpr (v: M3.Value): M3.Expr;
(* == ASSERT (FALSE) *)

PROCEDURE NoType (v: M3.Value): M3.Type;
(* == ASSERT (FALSE) *)

PROCEDURE NoLoader (v: M3.Value): M3.Temp;
(* == ASSERT (FALSE) *)

PROCEDURE NoWriter (v: M3.Value);
(* == ASSERT (FALSE) *)

PROCEDURE NoDeclarer (v: M3.Value);
(* == noop *)

PROCEDURE Never (v: M3.Value): BOOLEAN;
(* returns FALSE *)

PROCEDURE Always (v: M3.Value): BOOLEAN;
(* returns TRUE *)

PROCEDURE TypeVoid (v: M3.Value): M3.Type;
(* == RETURN Void.T *)

PROCEDURE Self (v: M3.Value): M3.Value;
(* == RETURN v *)

END ValueRep.
