(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Last modified on Tue Feb 11 20:50:16 PST 1992 by muller                   *)

GENERIC INTERFACE QueueADT (Elt);

(* The Queue abstract data TYPE.

   The type 'T' defines the basic operations available from all 
   implementations of queues.  The 'new' operation may be redefined with
   a different signature in subtypes of 'T'.  Also, subtypes may
   define additional methods.  

   Interfaces that define implementations of Queue may require actual 
   arguments that are more strict than Elt.

   A simple implementation is provided by the Queue interface. *)

EXCEPTION
  Empty;

TYPE
  F = PROCEDURE (x: Elt.T) RAISES ANY;
        (* to iterate over the elements of a queue *)

  T = OBJECT METHODS
        new (): T := new;
          (* create (self = NIL) or initialize (self # NIL) a Stack.T *)

        insert (e: Elt.T);
          (* insert 'e' at the end of 'self' *)
        delete (): Elt.T RAISES {Empty};
          (* if 'self' is not emtpy, remove the element at the front
             of 'self' and return that element.  Otherwise, raise Emtpy. *)
        first  (): Elt.T RAISES {Empty};
          (* if 'self' is not emtpy, return the element at the front
             of 'self'.  Otherwise, raise Emtpy. *)

        equal (t: T): BOOLEAN;
          (* TRUE iff 'self' and 't' are equal *)
        isEmpty (): BOOLEAN;
          (* TRUE iff 'self' is empty *)
        size (): CARDINAL;
          (* return the number of elements in 'self' *)
        copy (): T;
          (* return a copy of 'self' *)
        map (f: F) RAISES ANY;
          (* apply 'f' to each element of 'self'.  It is an unchecked runtime
             error to modify 'self' while this procedure is active *)
        END;

PROCEDURE new (self: T): T;

END QueueADT.
