(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)
(*                                                             *)
(* Last modified on Tue Sep 22 14:14:17 PDT 1992 by meehan     *)
(*      modified on Tue Jun 16 21:55:41 PDT 1992 by muller     *)
(*      modified on Tue Apr 28 08:35:50 1992 by mhb            *)

(* This interface declares a type for each component in the
   language.  A client wishing to subclass the VBT used by a
   component should be sure that the VBT returned by the
   overrideVBT method is a subtype of type listed here. *)

INTERFACE FVTypes;

IMPORT AnchorSplit, BooleanVBT, BorderedVBT, ChoiceVBT,
       FileBrowserVBT, Filter, FlexVBT, GuardedBtnVBT, HVSplit,
       HighlightVBT, ListVBT, MenuSwitchVBT, NumericScrollerVBT,
       NumericVBT, PackSplit, PixmapVBT, Radio, ReactivityVBT,
       ScaleFilter, Shadow, ShadowedVBT, ShadowedBarVBT,
       SourceVBT, SplitterVBT, SwitchVBT, TSplit, TextEditVBT,
       TextPort, TextureVBT, TextVBT, TrillSwitchVBT,
       TypescriptVBT, VBT, ViewportVBT, ZChassisVBT, ZGrowVBT,
       ZMoveVBT, ZChildVBT, ZTilps;

TYPE
  FVBar = FlexVBT.T BRANDED OBJECT END;
  FVBoolean <: BooleanVBT.T;
  FVBorder = BorderedVBT.T BRANDED OBJECT END;
  FVBrowser = ListVBT.T BRANDED OBJECT END;
  (* FVBrowser requires a UniSelector *)
  FVButton <: SwitchVBT.T;
  FVChisel = ShadowedBarVBT.T BRANDED OBJECT END;
  FVChoice <: ChoiceVBT.T;
  FVCloseButton <: PublicCloseButton;
  FVDirMenu = FileBrowserVBT.DirMenu BRANDED OBJECT END;
  FVFileBrowser <: FileBrowserVBT.T;
  FVFill = FlexVBT.T BRANDED OBJECT END;
  FVFilter = ReactivityVBT.T BRANDED OBJECT END;
  FVFrame = ShadowedVBT.T BRANDED OBJECT END;
  FVGeneric = FlexVBT.T BRANDED OBJECT END;
  FVGlue = FlexVBT.T BRANDED OBJECT END;
  FVGuard <: GuardedBtnVBT.T;
  FVHBox <: HVSplit.T;
  FVHPackSplit = PackSplit.T;
  FVHTile <: SplitterVBT.T;
  FVHelper = FileBrowserVBT.Helper BRANDED OBJECT END;
  FVLinkButton <: PublicLinkButton;
  FVMButton <: MenuSwitchVBT.T;
  FVMenu <: AnchorSplit.T;
  FVMenuBar = Filter.T BRANDED OBJECT END;
  FVMultiBrowser = ListVBT.T BRANDED OBJECT END;
  (* FVMultiBrowser requires a MultiSelector *)
  FVNumeric <: NumericVBT.T;
  FVPageButton <: PublicPageButton;
  FVPixmap = PixmapVBT.T BRANDED OBJECT END;
  FVPopButton <: SwitchVBT.T;
  FVPopMButton <: MenuSwitchVBT.T;
  FVRadio = PublicRadio;
  FVRidge = ShadowedBarVBT.T BRANDED OBJECT END;
  FVRim = BorderedVBT.T BRANDED OBJECT END;
  FVScale = ScaleFilter.T BRANDED OBJECT END;
  FVScroller <: NumericScrollerVBT.T;
  FVShape = FlexVBT.T BRANDED OBJECT END;
  FVSource <: SourceVBT.T OBJECT OVERRIDES hit := SourceVBT.AlwaysHit END;
  FVTSplit = PublicTSplit;
  FVTarget = Filter.T BRANDED OBJECT END;
  FVText = TextVBT.T BRANDED OBJECT END;
  FVTextArea = TextEditVBT.T BRANDED OBJECT END;
  (* FVTextArea requires a Port *)
  FVTextEdit = TextEditVBT.T BRANDED OBJECT END;
  (* FVTextEdit requires a Port *)
  FVTexture = TextureVBT.T BRANDED OBJECT END;
  FVTrillButton <: TrillSwitchVBT.T;
  FVTypeIn = TextEditVBT.T BRANDED OBJECT END;
  (* FVTypeIn requires a Port *)
  FVTypescript = TypescriptVBT.T BRANDED OBJECT END;
  (* FVTypescript requires a TypescriptPort *)
  FVVBox <: HVSplit.T;
  FVVTile <: SplitterVBT.T;
  FVViewport = ViewportVBT.T BRANDED OBJECT END;
  FVZBackground = HighlightVBT.T BRANDED OBJECT END;
  FVZChassis <: ZChassisVBT.T;
  FVZChild = ZChildVBT.T BRANDED OBJECT END;
  FVZGrow = ZGrowVBT.T BRANDED OBJECT END;
  FVZMove = ZMoveVBT.T BRANDED OBJECT END;
  FVZSplit = ZTilps.T BRANDED OBJECT END;

TYPE Port <: TextPort.T;
(* If you create a subtype of "FVTextArea", "FVTextEdit", or
   "FVTypeIn", its ".port" field must be "NIL" or a subtype of
   "FVTypes.Port". *)

TYPE TypescriptPort <: TypescriptVBT.Port;
(* If you create a subtype of "FVTypescript", its ".port" field
   must be "NIL" or a subtype of "FVTypes.TypescriptPort". *)

TYPE UniSelector <: ListVBT.UniSelector;
(* If you create a subtype of "FVBrowser", its ".selector" field
   must be "NIL" or a subtype of "FVTypes.UniSelector".*)

TYPE MultiSelector <: ListVBT.MultiSelector;
(* If you create a subtype of "FVBrowser", its ".selector" field
   must be "NIL" or a subtype of "FVTypes.MultiSelector". *)

TYPE
  PublicCloseButton =
    SwitchVBT.T OBJECT
    METHODS
      init (ch: VBT.T; shadow: Shadow.T): FVCloseButton
    END;

  PublicLinkButton =
    SwitchVBT.T OBJECT
    METHODS
      init (ch: VBT.T; shadow: Shadow.T): FVLinkButton
    END;

  PublicPageButton =
    SwitchVBT.T OBJECT
    METHODS
      init (ch: VBT.T; shadow: Shadow.T; backwards: BOOLEAN):
            FVPageButton
    END;

  PublicRadio = Filter.T OBJECT radio: Radio.T END;

  PublicTSplit = TSplit.T OBJECT circular := FALSE END;

END FVTypes.
