(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Created 1990-01-19 by Jorge Stolfi                          *)
(*   based on Real.i3 by Eric Muller and Bill Kalsow           *)
(* Last modified on Tue Jun  2 13:00:09 PDT 1992 by stolfi     *)
(*      modified on Tue Feb 11 21:39:52 PST 1992 by muller     *)


UNSAFE MODULE ByteRGB;

PROCEDURE New (value: T): REF T =
  VAR r: REF T;
  BEGIN
    r := NEW (REF T);
    r^ := value;
    RETURN r;
  END New;

PROCEDURE NewArray (size: CARDINAL;  value: T := T{0,0,0}): REF ARRAY OF T =
  VAR arr: REF ARRAY OF T;
  BEGIN
    arr := NEW (REF ARRAY OF T, size);
    FOR i := 0 TO size - 1 DO arr[i] := value END;
    RETURN arr
  END NewArray;

PROCEDURE UntracedNew (value: T): UNTRACED REF T =
  VAR r: UNTRACED REF T;
  BEGIN
    r := NEW (UNTRACED REF T);
    r^ := value;
    RETURN r;
  END UntracedNew;

PROCEDURE UntracedNewArray (
    size: CARDINAL;
    value: T := T{0,0,0}
  ): UNTRACED REF ARRAY OF T =
  VAR arr: UNTRACED REF ARRAY OF T;
  BEGIN
    arr := NEW (UNTRACED REF ARRAY OF T, size);
    FOR i := 0 TO size - 1 DO arr[i] := value END;
    RETURN arr
  END UntracedNewArray;

PROCEDURE Hash (a: T): INTEGER =
  BEGIN
    RETURN (a[2] * 256 + a[1]) * 256 + a[0];
  END Hash;

PROCEDURE ToBytes (x: T): Bytes = 
  BEGIN 
    RETURN LOOPHOLE (x, Bytes) 
  END ToBytes;

BEGIN
  <* ASSERT BITSIZE(T) MOD 8 = 0 *>    (* Assumed by ToBytes, Hash *)
END ByteRGB.

