(* Copyright (C) 1991, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Fri Feb 28 20:16:29 PST 1992 by stolfi     *)
(*      modified on Wed Sep 25 01:03:50 1991 by kalsow         *)
(*      modified on Mon Jul  1 20:00:30 1991 by muller         *)

INTERFACE Extended;

(* Properties of EXTENDED (for the VAX).

   This package defines some basic properties of the 
   built-in float type EXTENDED, for the VAX architecture.

   Index: EXTENDED; floating-point; generics
*)

TYPE T = EXTENDED;

CONST
  Base: INTEGER = 2;
  (* The radix of the floating-point representation for T *)

  Precision: INTEGER = 56;
  (* The number of digits of precision in the given Base for T. *)

  MaxFinite: T = 1.70141183460469230X+38;
  (* The maximum finite value in T.  For non-IEEE implementations,
     this is the same as LAST(T). *)

  MinPos: T = 2.93873587705571880X-39;
  (* The minimum positive value in T. *)

  MinPosNormal: T = MinPos;
  (* The minimum positive "normal" value in T; differs from MinPos
     only for implementations with denormalized numbers. *)

END Extended.
