(* Copyright (C) 1991, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Fri Feb 28 20:17:40 PST 1992 by stolfi     *)
(*      modified on Wed Sep 25 00:29:21 1991 by kalsow         *)
(*      modified on Mon Jul  1 19:59:36 1991 by muller         *)

INTERFACE LongReal; 

(* Basic properties OF LONGREAL (for the VAX).

   This package defines some basic properties of the 
   built-in float type LONGREAL, for the VAX architecture.

   Index: LONGREAL; floating-point; generics
*)

TYPE T = LONGREAL; 

CONST 
  Base: INTEGER = 2; 
  (* The radix of the floating-point representation for T *)

  Precision: INTEGER = 56;
  (* The number of digits of precision in the given Base for T. *)

  MaxFinite: T = 1.70141183460469230D+38;
  (* The maximum finite value in T.  For non-IEEE implementations,
     this is the same as LAST(T). *)

  MinPos: T = 2.93873587705571880D-39;
  (* The minimum positive value in T. *)

  MinPosNormal: T = MinPos;
  (* The minimum positive "normal" value in T; differs from MinPos
     only for implementations with denormalized numbers. *)

END LongReal.
