(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Wed Oct 30 09:34:07 PST 1991 by kalsow         *)
(*      modified on Thu Nov  1 02:13:46 1990 by muller         *)


INTERFACE RTMath;

(* This interface provides runtime routines to complete the
   set of mathematical operations provided by the machine. *)

PROCEDURE Ceiling (r: LONGREAL): INTEGER;
(* returns CEILING (r) *)

PROCEDURE Floor (r: LONGREAL): INTEGER;
(* returns FLOOR (r) *)

PROCEDURE Round (r: LONGREAL): INTEGER;
(* returns ROUND (r) *)

PROCEDURE Trunc (r: LONGREAL): INTEGER;
(* returns TRUNC(r) *)

PROCEDURE IDiv  (a, b: INTEGER): INTEGER;
(* returns a DIV b *)

PROCEDURE IMod  (a, b: INTEGER): INTEGER;
(* returns a MOD b *)

CONST MAXSET = 1000000;
PROCEDURE SetIncl (VAR x: ARRAY [0..MAXSET] OF INTEGER;  a, b: INTEGER);
(* sets bits [a..b] in the set x *)

END RTMath.

