MODULE CharType;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

<*INLINE*> PROCEDURE IsAlphaNumeric(ch: CHAR): BOOLEAN RAISES {}=
  BEGIN
    RETURN ch IN AlphaNumeric;
  END IsAlphaNumeric;


<*INLINE*> PROCEDURE IsAlphabetic(ch: CHAR): BOOLEAN RAISES {}=
  BEGIN
    RETURN ch IN Alphabetic;
  END IsAlphabetic;


<*INLINE*> PROCEDURE IsCntrl(ch: CHAR): BOOLEAN RAISES {}=
  BEGIN
    RETURN ch >= '\177' OR ORD(ch) < 8_40;
  END IsCntrl;


<*INLINE*> PROCEDURE IsDigit(ch: CHAR): BOOLEAN RAISES {}=
  BEGIN
    RETURN ch IN Digit;
  END IsDigit;


<*INLINE*> PROCEDURE IsGraphic(ch: CHAR): BOOLEAN RAISES {}=
  BEGIN
    RETURN ORD(ch) >= 8_41 AND ORD(ch) <= 8_176;
  END IsGraphic;


<*INLINE*> PROCEDURE IsLower(ch: CHAR): BOOLEAN RAISES {}=
  BEGIN
    RETURN ch IN Lower;
  END IsLower;


<*INLINE*> PROCEDURE IsPrintable(ch: CHAR): BOOLEAN RAISES {}=
  BEGIN
    RETURN ORD(ch) >= 8_40 AND ORD(ch) <= 8_176;
  END IsPrintable;


<*INLINE*> PROCEDURE IsPunctuation(ch: CHAR): BOOLEAN RAISES {}=
  BEGIN
    RETURN NOT (IsCntrl(ch) OR IsAlphabetic(ch));
  END IsPunctuation;


<*INLINE*> PROCEDURE IsWhitespace(ch: CHAR): BOOLEAN RAISES {}=
  BEGIN
    RETURN ch IN WhiteSpace;
  END IsWhitespace;


<*INLINE*> PROCEDURE IsUpper(ch: CHAR): BOOLEAN RAISES {}=
  BEGIN
    RETURN ch IN Upper;
  END IsUpper;


<*INLINE*> PROCEDURE IsHexDigit(ch: CHAR): BOOLEAN RAISES {}=
  BEGIN
    RETURN ch IN HexDigit;
  END IsHexDigit;


<*INLINE*> PROCEDURE IsEndOfLine(ch: CHAR): BOOLEAN RAISES {}=
  BEGIN
    RETURN ch IN EndOfLine;
  END IsEndOfLine;


<*INLINE*> PROCEDURE ToLower(ch: CHAR): CHAR RAISES {}=
  BEGIN
    IF ch IN Upper THEN
      RETURN VAL(ORD(ch) - ORD('A') + ORD('a'), CHAR);
    ELSE
      RETURN ch;
    END;
  END ToLower;


<*INLINE*> PROCEDURE ToUpper(ch: CHAR): CHAR RAISES {}=
  BEGIN
    IF ch IN Lower THEN
      RETURN VAL(ORD(ch) - ORD('a') + ORD('A'), CHAR);
    ELSE
      RETURN ch;
    END;
  END ToUpper;


BEGIN
END CharType.
