INTERFACE HeapStream;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT IO;


PROCEDURE Open(name := "heap"): IO.Stream RAISES {};
(* Opens a stream to the heap. This is useful for temporary storage of data
which can be written out using stream put operations and then read in again
with 'get' operations.
  'name' gives the name of the stream. The only open mode that makes sense is
'IO.OpenMode.Update' so there is no open mode argument (see the 'IO' interface
for more information on open modes). *)

END HeapStream.
