INTERFACE PathNameStream;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT IO;


PROCEDURE Open(
    name: TEXT;
    mode: IO.OpenMode := IO.OpenMode.Update;
    quiet: BOOLEAN := FALSE)
    : IO.Stream
    RAISES {IO.Error};
(* Opens a stream to the named file. The name of the stream will be the name of
the file. 'mode' gives the open mode to use (see the 'IO' interface for more
details about 'mode'.
  'quiet' controls the behaviour of 'Open' if the named file cannot be opened.
If 'quiet' is FALSE 'IO.Error' will be raised. The argument to 'IO.Error' will
be a stream with the name 'name'. This stream is useless for any reading or
writing operations but can be used to find out more details about the error.
  If 'quiet' is TRUE and the named file cannot be opened because it cannot be
found 'Open' will just return NIL. If the file cannot be opened for some other
reason (e.g. 'name' is an illegal path name or 'name' can be found but is
inaccessible) 'IO.Error' will be raised as described earlier.
  Note that some systems allow a file to be written by one process while it is
being read/written by another. A stream opened to a file which is being
concurrently written will not always reflect the current state of the file. In
particular the length (as given by 'IO.Length' or sought to by 'IO.Seek') will
be wrong and, because the stream is buffered, a read may not get the very
latest value of a given byte in a file *)

END PathNameStream.
