UNSAFE MODULE TimeElapsed_ux EXPORTS TimeElapsed;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT TimeDate, TimeDate_ux, Unix, Utime, OSError;

VAR
  startTime_g: Utime.struct_timeval;


PROCEDURE CPU(): INTEGER RAISES {OSError.E}=
  VAR
    now: Utime.struct_timeval;
  BEGIN
    TimeDate_ux.GetTimeOfDay(now);
    RETURN (now.tv_sec - startTime_g.tv_sec) * TicksPerSecond +
        (now.tv_usec - startTime_g.tv_usec) DIV (TimeDate.Mega DIV TicksPerSecond);
  END CPU;


BEGIN
  (* the following is the only time 'startTime_g' is written to and as it
   occurs during initialization no locking is necessary. If getting the time of
   day fails it will be fatal *)
  TimeDate_ux.GetTimeOfDay(startTime_g); <* UNEXPECTED OSError.E *>
END TimeElapsed_ux.
