(* Copyright (C) 1991, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

INTERFACE M3ShowProc;

IMPORT Wr;
IMPORT AST, ASTWalk;

TYPE
  Handle <: Public;
  Public = ASTWalk.Closure OBJECT
    wr: Wr.T;
  END;

PROCEDURE NewHandle(wr: Wr.T): Handle;
(* Creates a new handle suitable for passing to "ASTWalk.VisitNodes",
   or directly to "Node", from another walk. The "callback" method
   is set to "Node". *)

PROCEDURE Node(h: Handle; n: AST.NODE; vm: ASTWalk.VisitMode);
(* If "n" is a "Proc_decl" node, output its name on "h.wr". *)

END M3ShowProc.
