INTERFACE M3ASTQueryImpl;

(* Copyright (C) 1991, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

IMPORT M3AST;

EXCEPTION BadAttribute;

TYPE
  NodeToBoolProcType = PROCEDURE(n: M3AST.NODE): BOOLEAN RAISES {};
  NodeAndTextToBoolProcType =
      PROCEDURE(t: TEXT; n: M3AST.NODE): BOOLEAN RAISES {BadAttribute};
  NodeAndIntToNodeProcType =
      PROCEDURE(i: INTEGER; n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute};
  NodeToNodeProcType =
      PROCEDURE(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute};
  NodeToIntProcType = PROCEDURE(n: M3AST.NODE): INTEGER RAISES {BadAttribute};

  Proc = OBJECT END;
  NodeToBoolProc = Proc OBJECT p: NodeToBoolProcType; END;
  NodeToIntProc = Proc OBJECT p: NodeToIntProcType; END;
  NodeAndTextToBoolProc = Proc OBJECT p: NodeAndTextToBoolProcType; END;
  NodeAndIntToNodeProc = Proc OBJECT p: NodeAndIntToNodeProcType; END;
  NodeToNodeProc = Proc OBJECT p: NodeToNodeProcType; END;

PROCEDURE FindProc(name: TEXT): Proc RAISES {};
(* return a ProcObject to satisfy "name" *)

END M3ASTQueryImpl.
