MODULE M3ASTQueryImpl;

(* Copyright (C) 1991, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

IMPORT Text, HashText;
IMPORT M3AST, M3AST_AS, M3AST_SM;
IMPORT M3CId, M3Assert;
IMPORT AST, ASTNodeArray;

IMPORT
    SeqM3AST_AS_IMPORTED, SeqM3AST_AS_Import_item, SeqM3AST_AS_USED_ID,
    SeqM3AST_AS_Used_interface_id, SeqM3AST_AS_Used_def_id,
    SeqM3AST_AS_REVELATION, SeqM3AST_AS_DECL_REVL,
    SeqM3AST_AS_Const_decl, SeqM3AST_AS_TYPE_DECL,
    SeqM3AST_AS_Var_decl, SeqM3AST_AS_Exc_decl,
    SeqM3AST_AS_F_Interface_id,
    SeqM3AST_AS_Var_id, SeqM3AST_AS_Exc_id,
    SeqM3AST_AS_Enum_id, SeqM3AST_AS_Field_id,
    SeqM3AST_AS_FORMAL_ID, SeqM3AST_AS_Qual_used_id,
    SeqM3AST_AS_Fields, SeqM3AST_AS_Method, SeqM3AST_AS_Override,
    SeqM3AST_AS_M3TYPE, SeqM3AST_AS_TYPE_SPEC,
    SeqM3AST_AS_Formal_param, SeqM3AST_AS_CONS_ELEM,
    SeqM3AST_AS_EXP, SeqM3AST_AS_Actual,
    SeqM3AST_AS_Case, SeqM3AST_AS_STM,
    SeqM3AST_AS_Elsif, SeqM3AST_AS_Tcase,
    SeqM3AST_AS_Handler, SeqM3AST_AS_Binding,
    SeqM3AST_AS_RANGE_EXP;

IMPORT M3AST_AS_F, M3AST_SM_F, M3AST_TM_F;

TYPE
  SeqNODE = M3AST.NODE OBJECT seq: REFANY END;

PROCEDURE Null(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN n = NIL;
  END Null;

PROCEDURE Name(t: TEXT; n: M3AST.NODE): BOOLEAN RAISES {BadAttribute}=
  VAR void: M3AST_AS.USED_ID;
  BEGIN
    TYPECASE n OF
    | M3AST_AS.ID(id) => RETURN Text.Equal(M3CId.ToText(id.lx_symrep), t);
    | M3AST_AS.Exp_used_id(e_id) =>
        RETURN Text.Equal(M3CId.ToText(e_id.vUSED_ID.lx_symrep), t); 
    ELSE RAISE BadAttribute;
    END;
  END Name;

PROCEDURE Number(n: M3AST.NODE): INTEGER RAISES {}=
  BEGIN
    TYPECASE n OF
    | NULL => RETURN 0;
    | SeqNODE(seq) =>
        TYPECASE seq.seq OF
        | SeqM3AST_AS_IMPORTED.T(s) => RETURN SeqM3AST_AS_IMPORTED.Length(s);
        | SeqM3AST_AS_Import_item.T(s) => RETURN SeqM3AST_AS_Import_item.Length(s);
        | SeqM3AST_AS_USED_ID.T(s) => RETURN SeqM3AST_AS_USED_ID.Length(s);
        | SeqM3AST_AS_Used_interface_id.T(s) => RETURN SeqM3AST_AS_Used_interface_id.Length(s);
        | SeqM3AST_AS_Used_def_id.T(s) => RETURN SeqM3AST_AS_Used_def_id.Length(s);
        | SeqM3AST_AS_REVELATION.T(s) => RETURN SeqM3AST_AS_REVELATION.Length(s);
        | SeqM3AST_AS_DECL_REVL.T(s) => RETURN SeqM3AST_AS_DECL_REVL.Length(s);
        | SeqM3AST_AS_Const_decl.T(s) => RETURN SeqM3AST_AS_Const_decl.Length(s);
        | SeqM3AST_AS_TYPE_DECL.T(s) => RETURN SeqM3AST_AS_TYPE_DECL.Length(s);
        | SeqM3AST_AS_Var_decl.T(s) => RETURN SeqM3AST_AS_Var_decl.Length(s);
        | SeqM3AST_AS_Exc_decl.T(s) => RETURN SeqM3AST_AS_Exc_decl.Length(s);
        | SeqM3AST_AS_F_Interface_id.T(s) => RETURN SeqM3AST_AS_F_Interface_id.Length(s);
        | SeqM3AST_AS_Var_id.T(s) => RETURN SeqM3AST_AS_Var_id.Length(s);
        | SeqM3AST_AS_Exc_id.T(s) => RETURN SeqM3AST_AS_Exc_id.Length(s);
        | SeqM3AST_AS_Enum_id.T(s) => RETURN SeqM3AST_AS_Enum_id.Length(s);
        | SeqM3AST_AS_Field_id.T(s) => RETURN SeqM3AST_AS_Field_id.Length(s);
        | SeqM3AST_AS_FORMAL_ID.T(s) => RETURN SeqM3AST_AS_FORMAL_ID.Length(s);
        | SeqM3AST_AS_Qual_used_id.T(s) => RETURN SeqM3AST_AS_Qual_used_id.Length(s);
        | SeqM3AST_AS_Fields.T(s) => RETURN SeqM3AST_AS_Fields.Length(s);
        | SeqM3AST_AS_Method.T(s) => RETURN SeqM3AST_AS_Method.Length(s);
        | SeqM3AST_AS_Override.T(s) => RETURN SeqM3AST_AS_Override.Length(s);
        | SeqM3AST_AS_M3TYPE.T(s) => RETURN SeqM3AST_AS_M3TYPE.Length(s);
        | SeqM3AST_AS_TYPE_SPEC.T(s) => RETURN SeqM3AST_AS_TYPE_SPEC.Length(s);
        | SeqM3AST_AS_Formal_param.T(s) => RETURN SeqM3AST_AS_Formal_param.Length(s);
        | SeqM3AST_AS_CONS_ELEM.T(s) => RETURN SeqM3AST_AS_CONS_ELEM.Length(s);
        | SeqM3AST_AS_EXP.T(s) => RETURN SeqM3AST_AS_EXP.Length(s);
        | SeqM3AST_AS_Actual.T(s) => RETURN SeqM3AST_AS_Actual.Length(s);
        | SeqM3AST_AS_Case.T(s) => RETURN SeqM3AST_AS_Case.Length(s);
        | SeqM3AST_AS_STM.T(s) => RETURN SeqM3AST_AS_STM.Length(s);
        | SeqM3AST_AS_Elsif.T(s) => RETURN SeqM3AST_AS_Elsif.Length(s);
        | SeqM3AST_AS_Tcase.T(s) => RETURN SeqM3AST_AS_Tcase.Length(s);
        | SeqM3AST_AS_Handler.T(s) => RETURN SeqM3AST_AS_Handler.Length(s);
        | SeqM3AST_AS_Binding.T(s) => RETURN SeqM3AST_AS_Binding.Length(s);
        | SeqM3AST_AS_RANGE_EXP.T(s) => RETURN SeqM3AST_AS_RANGE_EXP.Length(s);
        END; (* typecase *)
    | M3AST.NODE =>
        RETURN ASTNodeArray.Number(n);
    END; (* typecase *)
  END Number;

PROCEDURE Ith(i: INTEGER; n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST.NODE =>
        RETURN ASTNodeArray.Ith(n, i);
    END; (* typecase *)
  END Ith;

PROCEDURE First(n: M3AST.NODE): M3AST.NODE RAISES {}=
  BEGIN
    TYPECASE n OF
    | M3AST.NODE =>
        RETURN ASTNodeArray.Ith(n, 0);
    END; (* typecase *)
  END First;

PROCEDURE Second(n: M3AST.NODE): M3AST.NODE RAISES {}=
  BEGIN
    TYPECASE n OF
    | M3AST.NODE =>
        RETURN ASTNodeArray.Ith(n, 1);
    END; (* typecase *)
  END Second;

(*---------------------------------------------------------------------------*)
(*                         NodeToBoolProcs (classes)                         *)
(*---------------------------------------------------------------------------*)

PROCEDURE ID(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.ID) OR ISTYPE(n, M3AST_AS.Exp_used_id);
  END ID;

PROCEDURE DEF_ID(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.DEF_ID);
  END DEF_ID;

PROCEDURE UNIT_ID(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.UNIT_ID);
  END UNIT_ID;

PROCEDURE TYPED_ID(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.TYPED_ID);
  END TYPED_ID;

PROCEDURE FORMAL_ID(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.FORMAL_ID);
  END FORMAL_ID;

PROCEDURE METHOD_OVERRIDE_ID(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.METHOD_OVERRIDE_ID);
  END METHOD_OVERRIDE_ID;

PROCEDURE USED_ID(n: M3AST.NODE): BOOLEAN RAISES {}=
  VAR void: M3AST_AS.USED_ID;
  BEGIN
    RETURN M3AST_AS.IsA_USED_ID(n, void);
  END USED_ID;

PROCEDURE UNIT(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.UNIT);
  END UNIT;

PROCEDURE UNIT_WITH_BODY(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.UNIT_WITH_BODY);
  END UNIT_WITH_BODY;

PROCEDURE UNIT_GEN_DEF(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.UNIT_GEN_DEF);
  END UNIT_GEN_DEF;

PROCEDURE UNIT_NORMAL(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.UNIT_NORMAL);
  END UNIT_NORMAL;

PROCEDURE UNIT_GEN_INS(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.UNIT_GEN_INS);
  END UNIT_GEN_INS;

PROCEDURE IMPORTED(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.IMPORTED);
  END IMPORTED;

PROCEDURE DECL_REVL(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.DECL_REVL);
  END DECL_REVL;

PROCEDURE DECL(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.DECL);
  END DECL;

PROCEDURE TYPE_DECL(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.TYPE_DECL);
  END TYPE_DECL;

PROCEDURE REVELATION(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.REVELATION);
  END REVELATION;

PROCEDURE EXP_TYPE(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.EXP_TYPE);
  END EXP_TYPE;

PROCEDURE M3TYPE(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.M3TYPE);
  END M3TYPE;

PROCEDURE TYPE_SPEC(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.TYPE_SPEC);
  END TYPE_SPEC;

PROCEDURE BRANDED_TYPE(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.BRANDED_TYPE);
  END BRANDED_TYPE;

PROCEDURE FLOAT_TYPE(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.FLOAT_TYPE);
  END FLOAT_TYPE;

PROCEDURE METHOD_OVERRIDE(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.METHOD_OVERRIDE);
  END METHOD_OVERRIDE;

PROCEDURE RAISEES(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.RAISEES);
  END RAISEES;

PROCEDURE RANGE_EXP(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.RANGE_EXP);
  END RANGE_EXP;

PROCEDURE EXP(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.EXP);
  END EXP;

PROCEDURE NUMERIC_LITERAL(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.NUMERIC_LITERAL);
  END NUMERIC_LITERAL;

PROCEDURE CONS_ELEM(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.CONS_ELEM);
  END CONS_ELEM;

PROCEDURE RANGE_EXP_elem(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.RANGE_EXP_elem);
  END RANGE_EXP_elem;

PROCEDURE BINARY_OP(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.BINARY_OP);
  END BINARY_OP;

PROCEDURE UNARY_OP(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.UNARY_OP);
  END UNARY_OP;

PROCEDURE STM(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.STM);
  END STM;

PROCEDURE STM_WSS(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.STM_WSS);
  END STM_WSS;

PROCEDURE SUBSTM_WSS(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.SUBSTM_WSS);
  END SUBSTM_WSS;

PROCEDURE TRY_TAIL(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.TRY_TAIL);
  END TRY_TAIL;

PROCEDURE INIT_ID (n: M3AST.NODE): BOOLEAN RAISES {}=
  VAR void: M3AST_SM.INIT_ID;
  BEGIN
    RETURN M3AST_SM.IsA_INIT_ID(n, void);
  END INIT_ID ;

PROCEDURE CCV_ID (n: M3AST.NODE): BOOLEAN RAISES {}=
  VAR void: M3AST_SM.CCV_ID;
  BEGIN
    RETURN M3AST_SM.IsA_CCV_ID(n, void);
  END CCV_ID ;

PROCEDURE REDEF_ID (n: M3AST.NODE): BOOLEAN RAISES {}=
  VAR void: M3AST_SM.REDEF_ID;
  BEGIN
    RETURN M3AST_SM.IsA_REDEF_ID(n, void);
  END REDEF_ID ;

PROCEDURE RECOBJ_ID (n: M3AST.NODE): BOOLEAN RAISES {}=
  VAR void: M3AST_SM.RECOBJ_ID;
  BEGIN
    RETURN M3AST_SM.IsA_RECOBJ_ID(n, void);
  END RECOBJ_ID ;

(*---------------------------------------------------------------------------*)
(*                         NodeToBoolProcs (nodes)                           *)
(*---------------------------------------------------------------------------*)

PROCEDURE Module_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Module_id);
  END Module_id;

PROCEDURE Interface_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Interface_id);
  END Interface_id;

PROCEDURE Interface_AS_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Interface_AS_id);
  END Interface_AS_id;

PROCEDURE F_Interface_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.F_Interface_id);
  END F_Interface_id;

PROCEDURE F_Value_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.F_Value_id);
  END F_Value_id;

PROCEDURE F_Var_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.F_Var_id);
  END F_Var_id;

PROCEDURE F_Readonly_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.F_Readonly_id);
  END F_Readonly_id;

PROCEDURE Type_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Type_id);
  END Type_id;

PROCEDURE Const_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Const_id);
  END Const_id;

PROCEDURE Var_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Var_id);
  END Var_id;

PROCEDURE Proc_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Proc_id);
  END Proc_id;

PROCEDURE Enum_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Enum_id);
  END Enum_id;

PROCEDURE Method_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Method_id);
  END Method_id;

PROCEDURE Override_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Override_id);
  END Override_id;

PROCEDURE Field_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Field_id);
  END Field_id;

PROCEDURE For_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.For_id);
  END For_id;

PROCEDURE Handler_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Handler_id);
  END Handler_id;

PROCEDURE Tcase_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Tcase_id);
  END Tcase_id;

PROCEDURE With_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.With_id);
  END With_id;

PROCEDURE Exc_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Exc_id);
  END Exc_id;

PROCEDURE Used_interface_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Used_interface_id);
  END Used_interface_id;

PROCEDURE Used_def_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Used_def_id);
  END Used_def_id;

PROCEDURE Qual_used_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Qual_used_id);
  END Qual_used_id;

PROCEDURE Compilation_Unit(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Compilation_Unit);
  END Compilation_Unit;

PROCEDURE Interface_gen_def(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Interface_gen_def);
  END Interface_gen_def;

PROCEDURE Module_gen_def(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Module_gen_def);
  END Module_gen_def;

PROCEDURE Interface(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Interface);
  END Interface;

PROCEDURE Module(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Module);
  END Module;

PROCEDURE Module_gen_ins(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Module_gen_ins);
  END Module_gen_ins;

PROCEDURE Interface_gen_ins(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Interface_gen_ins);
  END Interface_gen_ins;

PROCEDURE Unsafe(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Unsafe);
  END Unsafe;

PROCEDURE Simple_import(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Simple_import);
  END Simple_import;

PROCEDURE From_import(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.From_import);
  END From_import;

PROCEDURE Import_item(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Import_item);
  END Import_item;

PROCEDURE Revelation_s(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Revelation_s);
  END Revelation_s;

PROCEDURE Const_decl_s(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Const_decl_s);
  END Const_decl_s;

PROCEDURE Type_decl_s(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Type_decl_s);
  END Type_decl_s;

PROCEDURE Var_decl_s(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Var_decl_s);
  END Var_decl_s;

PROCEDURE Exc_decl_s(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Exc_decl_s);
  END Exc_decl_s;

PROCEDURE Proc_decl(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Proc_decl);
  END Proc_decl;

PROCEDURE Const_decl(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Const_decl);
  END Const_decl;

PROCEDURE Var_decl(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Var_decl);
  END Var_decl;

PROCEDURE Exc_decl(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Exc_decl);
  END Exc_decl;

PROCEDURE Subtype_decl (n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Subtype_decl );
  END Subtype_decl ;

PROCEDURE Concrete_decl(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Concrete_decl);
  END Concrete_decl;

PROCEDURE Subtype_reveal (n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Subtype_reveal );
  END Subtype_reveal ;

PROCEDURE Concrete_reveal(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Concrete_reveal);
  END Concrete_reveal;

PROCEDURE Named_type(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Named_type);
  END Named_type;

PROCEDURE Integer_type(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Integer_type);
  END Integer_type;

PROCEDURE Real_type(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Real_type);
  END Real_type;

PROCEDURE LongReal_type(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.LongReal_type);
  END LongReal_type;

PROCEDURE Extended_type(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Extended_type);
  END Extended_type;

PROCEDURE Null_type(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Null_type);
  END Null_type;

PROCEDURE RefAny_type(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.RefAny_type);
  END RefAny_type;

PROCEDURE Address_type(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Address_type);
  END Address_type;

PROCEDURE Root_type(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Root_type);
  END Root_type;

PROCEDURE Enumeration_type(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Enumeration_type);
  END Enumeration_type;

PROCEDURE Subrange_type(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Subrange_type);
  END Subrange_type;

PROCEDURE Array_type(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Array_type);
  END Array_type;

PROCEDURE Record_type(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Record_type);
  END Record_type;

PROCEDURE Object_type(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Object_type);
  END Object_type;

PROCEDURE Set_type(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Set_type);
  END Set_type;

PROCEDURE Procedure_type(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Procedure_type);
  END Procedure_type;

PROCEDURE Ref_type(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Ref_type);
  END Ref_type;

PROCEDURE Packed_type(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Packed_type);
  END Packed_type;

PROCEDURE Opaque_type(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Opaque_type);
  END Opaque_type;

PROCEDURE Brand(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Brand);
  END Brand;

PROCEDURE Untraced(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Untraced);
  END Untraced;

PROCEDURE Fields(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Fields);
  END Fields;

PROCEDURE Method(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Method);
  END Method;

PROCEDURE Override(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Override);
  END Override;

PROCEDURE Formal_param(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Formal_param);
  END Formal_param;

PROCEDURE Raisees_some(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Raisees_some);
  END Raisees_some;

PROCEDURE Raisees_any(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Raisees_any);
  END Raisees_any;

PROCEDURE Range_EXP(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Range_EXP);
  END Range_EXP;

PROCEDURE Range(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Range);
  END Range;

PROCEDURE Integer_literal(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Integer_literal);
  END Integer_literal;

PROCEDURE Real_literal(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Real_literal);
  END Real_literal;

PROCEDURE LongReal_literal(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.LongReal_literal);
  END LongReal_literal;

PROCEDURE Extended_literal(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Extended_literal);
  END Extended_literal;

PROCEDURE Text_literal(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Text_literal);
  END Text_literal;

PROCEDURE Char_literal(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Char_literal);
  END Char_literal;

PROCEDURE Nil_literal(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Nil_literal);
  END Nil_literal;

PROCEDURE Exp_used_id(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Exp_used_id);
  END Exp_used_id;

PROCEDURE Constructor(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Constructor);
  END Constructor;

PROCEDURE Actual_elem(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Actual_elem);
  END Actual_elem;

PROCEDURE Propagate(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Propagate);
  END Propagate;

PROCEDURE Binary(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Binary);
  END Binary;

PROCEDURE Plus(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Plus);
  END Plus;

PROCEDURE Minus(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Minus);
  END Minus;

PROCEDURE Times(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Times);
  END Times;

PROCEDURE Rdiv(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Rdiv);
  END Rdiv;

PROCEDURE Textcat(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Textcat);
  END Textcat;

PROCEDURE Div(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Div);
  END Div;

PROCEDURE Mod(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Mod);
  END Mod;

PROCEDURE Eq(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Eq);
  END Eq;

PROCEDURE Ne(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Ne);
  END Ne;

PROCEDURE Gt(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Gt);
  END Gt;

PROCEDURE Lt(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Lt);
  END Lt;

PROCEDURE Ge(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Ge);
  END Ge;

PROCEDURE Le(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Le);
  END Le;

PROCEDURE And(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.And);
  END And;

PROCEDURE Or(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Or);
  END Or;

PROCEDURE In(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.In);
  END In;

PROCEDURE Select(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Select);
  END Select;

PROCEDURE Unary(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Unary);
  END Unary;

PROCEDURE Not(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Not);
  END Not;

PROCEDURE Unaryplus(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Unaryplus);
  END Unaryplus;

PROCEDURE Unaryminus(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Unaryminus);
  END Unaryminus;

PROCEDURE Deref(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Deref);
  END Deref;

PROCEDURE Call(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Call);
  END Call;

PROCEDURE Index(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Index);
  END Index;

PROCEDURE Actual(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Actual);
  END Actual;

PROCEDURE Assign_st(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Assign_st);
  END Assign_st;

PROCEDURE Call_st(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Call_st);
  END Call_st;

PROCEDURE Case_st(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Case_st);
  END Case_st;

PROCEDURE Eval_st(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Eval_st);
  END Eval_st;

PROCEDURE Exit_st(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Exit_st);
  END Exit_st;

PROCEDURE For_st(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.For_st);
  END For_st;

PROCEDURE If_st(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.If_st);
  END If_st;

PROCEDURE Lock_st(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Lock_st);
  END Lock_st;

PROCEDURE Loop_st(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Loop_st);
  END Loop_st;

PROCEDURE Raise_st(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Raise_st);
  END Raise_st;

PROCEDURE Repeat_st(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Repeat_st);
  END Repeat_st;

PROCEDURE Return_st(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Return_st);
  END Return_st;

PROCEDURE Try_st(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Try_st);
  END Try_st;

PROCEDURE Typecase_st(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Typecase_st);
  END Typecase_st;

PROCEDURE While_st(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.While_st);
  END While_st;

PROCEDURE With_st(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.With_st);
  END With_st;

PROCEDURE Block(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Block);
  END Block;

PROCEDURE Case(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Case);
  END Case;

PROCEDURE Else_stm(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Else_stm);
  END Else_stm;

PROCEDURE Elsif(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Elsif);
  END Elsif;

PROCEDURE Try_except(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Try_except);
  END Try_except;

PROCEDURE Try_finally(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Try_finally);
  END Try_finally;

PROCEDURE Tcase(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Tcase);
  END Tcase;

PROCEDURE Handler(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Handler);
  END Handler;

PROCEDURE Binding(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Binding);
  END Binding;

PROCEDURE By(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.By);
  END By;

PROCEDURE Bad_EXP(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Bad_EXP);
  END Bad_EXP;

PROCEDURE Bad_M3TYPE(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Bad_M3TYPE);
  END Bad_M3TYPE;

PROCEDURE Bad_STM(n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_AS.Bad_STM);
  END Bad_STM;

PROCEDURE Void_type (n: M3AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    RETURN ISTYPE(n, M3AST_SM.Void_type);
  END Void_type ;

(*---------------------------------------------------------------------------*)
(*                     NodeAttributeProcs                                    *)
(*---------------------------------------------------------------------------*)

PROCEDURE as_intf_id(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Qual_used_id(m) => RETURN m.as_intf_id;
    | M3AST_AS.Import_item(m) => RETURN m.as_intf_id;
    | M3AST_AS.From_import(m) => RETURN m.as_intf_id;
    ELSE
      RAISE BadAttribute
    END; (* typecase *)    
  END as_intf_id;

PROCEDURE as_id(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Qual_used_id(m) => RETURN m.as_id;
    | M3AST_AS.UNIT(m) => RETURN m.as_id;
    | M3AST_AS.Import_item(m) => RETURN m.as_id;
    | M3AST_AS.TYPE_DECL(m) => RETURN m.as_id;
    | M3AST_AS.Exc_decl(m) => RETURN m.as_id;
    | M3AST_AS.Proc_decl(m) => RETURN m.as_id;
    | M3AST_AS.METHOD_OVERRIDE(m) => RETURN m.as_id;
    | M3AST_AS.Actual(m) => RETURN m.as_id;
    | M3AST_AS.For_st(m) => RETURN m.as_id;
    | M3AST_AS.Handler(m) => RETURN m.as_id;
    | M3AST_AS.Tcase(m) => RETURN m.as_id;
    | M3AST_AS.Binding(m) => RETURN m.as_id;
    ELSE
      RAISE BadAttribute
    END; (* typecase *)
  END as_id;

PROCEDURE as_root(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Compilation_Unit(m) => RETURN m.as_root;
    ELSE RAISE BadAttribute
    END
  END as_root;

PROCEDURE as_import_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.UNIT_WITH_BODY(m) => RETURN NEW(SeqNODE, seq := m.as_import_s);
    ELSE RAISE BadAttribute
    END
  END as_import_s ;

PROCEDURE as_block(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.UNIT_WITH_BODY(m) => RETURN m.as_block;
    ELSE RAISE BadAttribute
    END
  END as_block;

PROCEDURE as_id_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  VAR s: REFANY;
  BEGIN
    TYPECASE n OF
    | M3AST_AS.UNIT_GEN_DEF(m) => s := m.as_id_s;
    | M3AST_AS.UNIT_GEN_INS(m) => s := m.as_id_s;
    | M3AST_AS.From_import(m) => s := m.as_id_s;
    | M3AST_AS.Var_decl(m) => s := m.as_id_s;
    | M3AST_AS.Enumeration_type(m) => s := m.as_id_s;
    | M3AST_AS.Fields(m) => s :=  m.as_id_s;
    | M3AST_AS.Formal_param(m) => s := m.as_id_s;
    ELSE RAISE BadAttribute
    END;
    RETURN NEW(SeqNODE, seq := s);
  END as_id_s ;

PROCEDURE as_unsafe(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.UNIT_GEN_INS(m) => RETURN m.as_unsafe;
    | M3AST_AS.UNIT_NORMAL(m) => RETURN m.as_unsafe;
    ELSE RAISE BadAttribute
    END
  END as_unsafe;

PROCEDURE as_export_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Module(m) => RETURN NEW(SeqNODE, seq := m.as_export_s);
    | M3AST_AS.Module_gen_ins(m) => RETURN NEW(SeqNODE, seq := m.as_export_s);
    ELSE RAISE BadAttribute
    END
  END as_export_s ;

PROCEDURE as_gen_id(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.UNIT_GEN_INS(m) => RETURN m.as_gen_id;
    ELSE RAISE BadAttribute
    END
  END as_gen_id;

PROCEDURE as_import_item_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Simple_import(m) => RETURN NEW(SeqNODE, seq := m.as_import_item_s);
    ELSE RAISE BadAttribute
    END
  END as_import_item_s ;

PROCEDURE as_reveal_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Revelation_s(m) => RETURN NEW(SeqNODE, seq := m.as_reveal_s);
    ELSE RAISE BadAttribute
    END
  END as_reveal_s ;

PROCEDURE as_const_decl_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Const_decl_s(m) => RETURN NEW(SeqNODE, seq := m.as_const_decl_s);
    ELSE RAISE BadAttribute
    END
  END as_const_decl_s ;

PROCEDURE as_type_decl_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Type_decl_s(m) => RETURN NEW(SeqNODE, seq := m.as_type_decl_s);
    ELSE RAISE BadAttribute
    END
  END as_type_decl_s ;

PROCEDURE as_var_decl_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Var_decl_s(m) => RETURN NEW(SeqNODE, seq := m.as_var_decl_s);
    ELSE RAISE BadAttribute
    END
  END as_var_decl_s ;

PROCEDURE as_exc_decl_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Exc_decl_s(m) => RETURN NEW(SeqNODE, seq := m.as_exc_decl_s);
    ELSE RAISE BadAttribute
    END
  END as_exc_decl_s ;

PROCEDURE as_type(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Const_decl(m) => RETURN m.as_type;
    | M3AST_AS.TYPE_DECL(m) => RETURN m.as_type;
    | M3AST_AS.Var_decl(m) => RETURN m.as_type;
    | M3AST_AS.Exc_decl(m) => RETURN m.as_type;
    | M3AST_AS.Proc_decl(m) => RETURN m.as_type;
    | M3AST_AS.REVELATION(m) => RETURN m.as_type;
    | M3AST_AS.Set_type(m) => RETURN m.as_type;
    | M3AST_AS.Packed_type(m) => RETURN m.as_type;
    | M3AST_AS.Ref_type(m) => RETURN m.as_type;
    | M3AST_AS.Fields(m) => RETURN m.as_type;
    | M3AST_AS.Method(m) => RETURN m.as_type;
    | M3AST_AS.Opaque_type(m) => RETURN m.as_type;
    | M3AST_AS.Constructor(m) => RETURN m.as_type;
    ELSE RAISE BadAttribute
    END
  END as_type;

PROCEDURE as_exp(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Const_decl(m) => RETURN m.as_exp;
    | M3AST_AS.Packed_type(m) => RETURN m.as_exp;
    | M3AST_AS.Brand(m) => RETURN m.as_exp;
    | M3AST_AS.Range_EXP(m) => RETURN m.as_exp;
    | M3AST_AS.Unary(m) => RETURN m.as_exp;
    | M3AST_AS.Case_st(m) => RETURN m.as_exp;
    | M3AST_AS.Eval_st(m) => RETURN m.as_exp;
    | M3AST_AS.By(m) => RETURN m.as_exp;
    | M3AST_AS.If_st(m) => RETURN m.as_exp;
    | M3AST_AS.Elsif(m) => RETURN m.as_exp;
    | M3AST_AS.Lock_st(m) => RETURN m.as_exp;
    | M3AST_AS.Return_st(m) => RETURN m.as_exp;
    | M3AST_AS.Repeat_st(m) => RETURN m.as_exp;
    | M3AST_AS.Typecase_st(m) => RETURN m.as_exp;
    | M3AST_AS.While_st(m) => RETURN m.as_exp;
    | M3AST_AS.Binding(m) => RETURN m.as_exp;
    ELSE RAISE BadAttribute
    END
  END as_exp;

PROCEDURE as_default(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Var_decl(m) => RETURN m.as_default;
    | M3AST_AS.Fields(m) => RETURN m.as_default;
    | M3AST_AS.METHOD_OVERRIDE(m) => RETURN m.as_default;
    | M3AST_AS.Formal_param(m) => RETURN m.as_default;
    ELSE RAISE BadAttribute
    END
  END as_default;

PROCEDURE as_body(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Proc_decl(m) => RETURN m.as_body;
    ELSE RAISE BadAttribute
    END
  END as_body;

PROCEDURE as_qual_id(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.REVELATION(m) => RETURN m.as_qual_id;
    | M3AST_AS.Named_type(m) => RETURN m.as_qual_id;
    | M3AST_AS.Raise_st(m) => RETURN m.as_qual_id;
    ELSE RAISE BadAttribute
    END
  END as_qual_id;

PROCEDURE as_trace_mode(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Root_type(m) => RETURN m.as_trace_mode;
    | M3AST_AS.Ref_type(m) => RETURN m.as_trace_mode;
    ELSE RAISE BadAttribute
    END
  END as_trace_mode;

PROCEDURE as_indextype_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Array_type(m) => RETURN NEW(SeqNODE, seq := m.as_indextype_s)
    ELSE RAISE BadAttribute
    END
  END as_indextype_s ;

PROCEDURE as_elementtype(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Array_type(m) => RETURN NEW(SeqNODE, seq := m.as_elementtype)
    ELSE RAISE BadAttribute
    END
  END as_elementtype;

PROCEDURE as_range(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Subrange_type(m) => RETURN m.as_range;
    ELSE RAISE BadAttribute
    END
  END as_range;

PROCEDURE as_fields_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  VAR s: REFANY;
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Record_type(m) => s := m.as_fields_s;
    | M3AST_AS.Object_type(m) => s := m.as_fields_s;
    ELSE RAISE BadAttribute
    END;
    RETURN NEW(SeqNODE, seq := s);
  END as_fields_s ;

PROCEDURE as_brand(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.BRANDED_TYPE(m) => RETURN m.as_brand
    ELSE RAISE BadAttribute
    END
  END as_brand;

PROCEDURE as_ancestor(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Object_type(m) => RETURN m.as_ancestor;
    ELSE RAISE BadAttribute
    END
  END as_ancestor;

PROCEDURE as_method_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Object_type(m) => RETURN NEW(SeqNODE, seq := m.as_method_s);
    ELSE RAISE BadAttribute
    END
  END as_method_s ;

PROCEDURE as_override_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Object_type(m) => RETURN NEW(SeqNODE, seq := m.as_override_s);
    ELSE RAISE BadAttribute
    END
  END as_override_s ;

PROCEDURE as_formal_param_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Procedure_type(m) => RETURN NEW(SeqNODE, seq := m.as_formal_param_s);
    ELSE RAISE BadAttribute
    END
  END as_formal_param_s ;

PROCEDURE as_result_type(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Procedure_type(m) => RETURN m.as_result_type;
    ELSE RAISE BadAttribute
    END
  END as_result_type;

PROCEDURE as_raises(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Procedure_type(m) => RETURN m.as_raises;
    ELSE RAISE BadAttribute
    END
  END as_raises;

PROCEDURE as_formal_type(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Formal_param(m) => RETURN m.as_formal_type;
    ELSE RAISE BadAttribute
    END
  END as_formal_type;

PROCEDURE as_raisees_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Raisees_some(m) => RETURN NEW(SeqNODE, seq := m.as_raisees_s);
    ELSE RAISE BadAttribute
    END
  END as_raisees_s ;

PROCEDURE as_exp1(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Range(m) => RETURN m.as_exp1;
    | M3AST_AS.Binary(m) => RETURN m.as_exp1;
    ELSE RAISE BadAttribute
    END
  END as_exp1;

PROCEDURE as_exp2(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Range(m) => RETURN m.as_exp2;
    | M3AST_AS.Binary(m) => RETURN m.as_exp2;
    ELSE RAISE BadAttribute
    END
  END as_exp2;

PROCEDURE as_element_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Constructor(m) => RETURN NEW(SeqNODE, seq := m.as_element_s);
    ELSE RAISE BadAttribute
    END
  END as_element_s ;

PROCEDURE as_propagate(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Constructor(m) => RETURN m.as_propagate;
    ELSE RAISE BadAttribute
    END
  END as_propagate;

PROCEDURE as_range_exp(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.RANGE_EXP_elem(m) => RETURN m.as_range_exp;
    ELSE RAISE BadAttribute
    END
  END as_range_exp;

PROCEDURE as_actual(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Actual_elem(m) => RETURN m.as_actual;
    ELSE RAISE BadAttribute
    END
  END as_actual;

PROCEDURE as_binary_op(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Binary(m) => RETURN m.as_binary_op;
    ELSE RAISE BadAttribute
    END
  END as_binary_op;

PROCEDURE as_unary_op(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Unary(m) => RETURN m.as_unary_op;
    ELSE RAISE BadAttribute
    END
  END as_unary_op;

PROCEDURE as_callexp(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Call(m) => RETURN m.as_callexp;
    ELSE RAISE BadAttribute
    END
  END as_callexp;

PROCEDURE as_param_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Call(m) => RETURN NEW(SeqNODE, seq := m.as_param_s)
    ELSE RAISE BadAttribute
    END
  END as_param_s ;

PROCEDURE as_exp_type(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Actual(m) => RETURN m.as_exp_type;
    ELSE RAISE BadAttribute
    END
  END as_exp_type;

PROCEDURE as_array(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Index(m) => RETURN m.as_array;
    ELSE RAISE BadAttribute
    END
  END as_array;

PROCEDURE as_exp_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Index(m) => RETURN NEW(SeqNODE, seq := m.as_exp_s);
    ELSE RAISE BadAttribute
    END
  END as_exp_s ;

PROCEDURE as_stm_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  VAR s: REFANY;
  BEGIN
    TYPECASE n OF
    | M3AST_AS.STM_WSS(m) => s := m.as_stm_s;
    | M3AST_AS.SUBSTM_WSS(m) => s :=  m.as_stm_s;
    ELSE RAISE BadAttribute
    END;
    RETURN NEW(SeqNODE, seq := s);
  END as_stm_s ;

PROCEDURE as_lhs_exp(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Assign_st(m) => RETURN m.as_lhs_exp;
    ELSE RAISE BadAttribute
    END
  END as_lhs_exp;

PROCEDURE as_rhs_exp(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Assign_st(m) => RETURN m.as_rhs_exp;
    ELSE RAISE BadAttribute
    END
  END as_rhs_exp;

PROCEDURE as_call(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Call_st(m) => RETURN m.as_call;
    ELSE RAISE BadAttribute
    END
  END as_call;

PROCEDURE as_case_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Case_st(m) => RETURN NEW(SeqNODE, seq := m.as_case_s);
    ELSE RAISE BadAttribute
    END
  END as_case_s ;

PROCEDURE as_else(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Case_st(m) => RETURN m.as_else;
    | M3AST_AS.If_st(m) => RETURN m.as_else;
    | M3AST_AS.Try_except(m) => RETURN m.as_else;
    | M3AST_AS.Typecase_st(m) => RETURN m.as_else;
    ELSE RAISE BadAttribute
    END
  END as_else;

PROCEDURE as_case_label_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Case(m) => RETURN NEW(SeqNODE, seq := m.as_case_label_s)
    ELSE RAISE BadAttribute
    END
  END as_case_label_s ;

PROCEDURE as_from(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.For_st(m) => RETURN m.as_from;
    ELSE RAISE BadAttribute
    END
  END as_from;

PROCEDURE as_to(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.For_st(m) => RETURN m.as_to;
    ELSE RAISE BadAttribute
    END
  END as_to;

PROCEDURE as_by(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.For_st(m) => RETURN m.as_by;
    ELSE RAISE BadAttribute
    END
  END as_by;

PROCEDURE as_elsif_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.If_st(m) => RETURN NEW(SeqNODE, seq := m.as_elsif_s);
    ELSE RAISE BadAttribute
    END
  END as_elsif_s ;

PROCEDURE as_exp_void(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Raise_st(m) => RETURN m.as_exp_void;
    ELSE RAISE BadAttribute
    END
  END as_exp_void;

PROCEDURE as_try_tail(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Try_st(m) => RETURN m.as_try_tail
    ELSE RAISE BadAttribute
    END
  END as_try_tail;

PROCEDURE as_handler_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Try_except(m) => RETURN NEW(SeqNODE, seq := m.as_handler_s)
    ELSE RAISE BadAttribute
    END
  END as_handler_s ;

PROCEDURE as_qual_id_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Handler(m) => RETURN NEW(SeqNODE, seq := m.as_qual_id_s);
    ELSE RAISE BadAttribute
    END
  END as_qual_id_s ;

PROCEDURE as_tcase_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Typecase_st(m) => RETURN NEW(SeqNODE, seq := m.as_tcase_s)
    ELSE RAISE BadAttribute
    END
  END as_tcase_s ;

PROCEDURE as_type_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Tcase(m) => RETURN NEW(SeqNODE, seq := m.as_type_s);
    ELSE RAISE BadAttribute
    END
  END as_type_s ;

PROCEDURE as_binding_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.With_st(m) => RETURN NEW(SeqNODE, seq := m.as_binding_s);
    ELSE RAISE BadAttribute
    END
  END as_binding_s ;

PROCEDURE as_decl_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Block(m) => RETURN NEW(SeqNODE, seq := m.as_decl_s);
    ELSE RAISE BadAttribute
    END
  END as_decl_s ;

PROCEDURE sm_import_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.UNIT_WITH_BODY(m) => RETURN NEW(SeqNODE, seq := m.sm_import_s);
    ELSE RAISE BadAttribute
    END;
  END sm_import_s ;

PROCEDURE sm_ins_comp_unit(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.UNIT_GEN_INS(m) => RETURN m.sm_ins_comp_unit;
    ELSE RAISE BadAttribute
    END;
  END sm_ins_comp_unit;

PROCEDURE sm_spec(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.UNIT_ID(m) => RETURN m.sm_spec;
    | M3AST_AS.Proc_id(m) => RETURN m.sm_spec;
    | M3AST_AS.METHOD_OVERRIDE_ID(m) => RETURN m.sm_spec;
    ELSE RAISE BadAttribute
    END;
  END sm_spec;

PROCEDURE sm_export_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Module(m) => RETURN NEW(SeqNODE, seq := m.sm_export_s);
    ELSE RAISE BadAttribute
    END;
  END sm_export_s ;

PROCEDURE sm_concrete_proc_id(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Proc_id(m) => RETURN m.sm_concrete_proc_id
    ELSE RAISE BadAttribute
    END;
  END sm_concrete_proc_id;

PROCEDURE sm_def(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  VAR u: M3AST_AS.USED_ID;
  BEGIN
    IF M3AST_AS.IsA_USED_ID(n, u) THEN RETURN u.sm_def;
    ELSE RAISE BadAttribute;
    END;
  END sm_def;

PROCEDURE sm_type_spec(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.TYPED_ID(m) => RETURN m.sm_type_spec;
    | M3AST_AS.Named_type(m) => RETURN m.sm_type_spec;
    ELSE RAISE BadAttribute
    END;
  END sm_type_spec;

PROCEDURE sm_concrete_type_spec(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Opaque_type(m) => RETURN m.sm_concrete_type_spec;
    ELSE RAISE BadAttribute
    END;
  END sm_concrete_type_spec;

PROCEDURE sm_type_spec_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Opaque_type(m) => RETURN NEW(SeqNODE, seq := m.sm_type_spec_s);
    ELSE RAISE BadAttribute
    END;
  END sm_type_spec_s ;

PROCEDURE sm_base_type_spec(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Subrange_type(m) => RETURN m.sm_base_type_spec;
    ELSE RAISE BadAttribute
    END;
  END sm_base_type_spec;

PROCEDURE sm_def_id(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Procedure_type(m) => RETURN m.sm_def_id;
    ELSE RAISE BadAttribute
    END;
  END sm_def_id;

PROCEDURE sm_bitsize (n: M3AST.NODE): INTEGER RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.TYPE_SPEC(m) => RETURN m.sm_bitsize;
    ELSE RAISE BadAttribute
    END;
  END sm_bitsize ;

PROCEDURE sm_align (n: M3AST.NODE): INTEGER RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.TYPE_SPEC(m) => RETURN m.sm_align;
    ELSE RAISE BadAttribute
    END;
  END sm_align ;

PROCEDURE sm_rf_bitsize (n: M3AST.NODE): INTEGER RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Object_type(m) => RETURN m.sm_rf_bitsize;
    ELSE RAISE BadAttribute
    END;
  END sm_rf_bitsize ;

PROCEDURE sm_rf_align (n: M3AST.NODE): INTEGER RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Object_type(m) => RETURN m.sm_rf_align;
    ELSE RAISE BadAttribute
    END;
  END sm_rf_align ;

PROCEDURE sm_exp_type_spec(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.EXP(m) => RETURN m.sm_exp_type_spec;
    ELSE RAISE BadAttribute
    END;
  END sm_exp_type_spec;

PROCEDURE sm_actual_s (n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Call(m) => RETURN NEW(SeqNODE, seq := m.sm_actual_s);
    | M3AST_AS.Constructor(m) => RETURN NEW(SeqNODE, seq := m.sm_actual_s);
    ELSE RAISE BadAttribute
    END;
  END sm_actual_s ;

PROCEDURE sm_int_def(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  VAR r: M3AST_SM.REDEF_ID;
  BEGIN
    IF M3AST_SM.IsA_REDEF_ID(n, r) THEN
      RETURN r.sm_int_def;
    ELSE
      RAISE BadAttribute
    END; (* if *)
  END sm_int_def;

PROCEDURE sm_init_exp(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  VAR r: M3AST_SM.INIT_ID;
  BEGIN
    IF M3AST_SM.IsA_INIT_ID(n, r) THEN
      RETURN r.sm_init_exp;
    ELSE
      RAISE BadAttribute
    END; (* if *)
  END sm_init_exp;

PROCEDURE sm_unit_id(n: M3AST.NODE): M3AST.NODE RAISES {BadAttribute}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.DEF_ID(d) =>
        RETURN d.tmp_unit_id;
    | M3AST_AS.TYPE_SPEC(t) =>
        RETURN t.tmp_unit_id;
    ELSE
      RAISE BadAttribute
    END; (* typecase *)
  END sm_unit_id;

PROCEDURE FindProc(name: TEXT): Proc RAISES {}=
  VAR id: HashText.Id; 
  BEGIN
    M3Assert.Check(HashText.Lookup(procTable_g, name, id));
    RETURN NARROW(HashText.Value(procTable_g, id), Proc);
  END FindProc;

PROCEDURE EnterNodeToBoolProc(name: TEXT; p: NodeToBoolProcType) RAISES {}=
  VAR id: HashText.Id; 
  BEGIN
    EVAL HashText.Enter(procTable_g, name, id);
    HashText.Associate(procTable_g, id, NEW(NodeToBoolProc, p := p));
  END EnterNodeToBoolProc;

PROCEDURE EnterNodeToIntProc(name: TEXT; p: NodeToIntProcType) RAISES {}=
  VAR id: HashText.Id; 
  BEGIN
    EVAL HashText.Enter(procTable_g, name, id);
    HashText.Associate(procTable_g, id, NEW(NodeToIntProc, p := p));
  END EnterNodeToIntProc;

PROCEDURE EnterNodeAndTextToBoolProc(name: TEXT;
    p: NodeAndTextToBoolProcType) RAISES {}=
  VAR id: HashText.Id;
  BEGIN
    EVAL HashText.Enter(procTable_g, name, id);
    HashText.Associate(procTable_g, id, NEW(NodeAndTextToBoolProc, p := p));
  END EnterNodeAndTextToBoolProc;

PROCEDURE EnterNodeAndIntToNodeProc(name: TEXT;
    p: NodeAndIntToNodeProcType) RAISES {}=
  VAR id: HashText.Id;
  BEGIN
    EVAL HashText.Enter(procTable_g, name, id);
    HashText.Associate(procTable_g, id, NEW(NodeAndIntToNodeProc, p := p));
  END EnterNodeAndIntToNodeProc;

PROCEDURE EnterNodeToNodeProc(name: TEXT;
    p: NodeToNodeProcType) RAISES {}=
  VAR id: HashText.Id;
  BEGIN
    EVAL HashText.Enter(procTable_g, name, id);
    HashText.Associate(procTable_g, id, NEW(NodeToNodeProc, p := p));
  END EnterNodeToNodeProc;


VAR
  procTable_g := HashText.New(512);
BEGIN
  EnterNodeToBoolProc("Null", Null);
  EnterNodeAndTextToBoolProc("Name", Name);
  EnterNodeToIntProc("Number", Number);
  EnterNodeAndIntToNodeProc("Ith", Ith);
  EnterNodeToNodeProc("First", First);
  EnterNodeToNodeProc("Second", Second);

  EnterNodeToBoolProc("ID", ID);
  EnterNodeToBoolProc("DEF_ID", DEF_ID);
  EnterNodeToBoolProc("UNIT_ID", UNIT_ID);
  EnterNodeToBoolProc("TYPED_ID", TYPED_ID);
  EnterNodeToBoolProc("FORMAL_ID", FORMAL_ID);
  EnterNodeToBoolProc("METHOD_OVERRIDE_ID", METHOD_OVERRIDE_ID);
  EnterNodeToBoolProc("USED_ID", USED_ID);
  EnterNodeToBoolProc("UNIT", UNIT);
  EnterNodeToBoolProc("UNIT_WITH_BODY", UNIT_WITH_BODY);
  EnterNodeToBoolProc("UNIT_GEN_DEF", UNIT_GEN_DEF);
  EnterNodeToBoolProc("UNIT_NORMAL", UNIT_NORMAL);
  EnterNodeToBoolProc("UNIT_GEN_INS", UNIT_GEN_INS);
  EnterNodeToBoolProc("IMPORTED", IMPORTED);
  EnterNodeToBoolProc("DECL_REVL", DECL_REVL);
  EnterNodeToBoolProc("DECL", DECL);
  EnterNodeToBoolProc("TYPE_DECL", TYPE_DECL);
  EnterNodeToBoolProc("REVELATION", REVELATION);
  EnterNodeToBoolProc("EXP_TYPE", EXP_TYPE);
  EnterNodeToBoolProc("M3TYPE", M3TYPE);
  EnterNodeToBoolProc("TYPE_SPEC", TYPE_SPEC);
  EnterNodeToBoolProc("BRANDED_TYPE", BRANDED_TYPE);
  EnterNodeToBoolProc("FLOAT_TYPE", FLOAT_TYPE);
  EnterNodeToBoolProc("METHOD_OVERRIDE", METHOD_OVERRIDE);
  EnterNodeToBoolProc("RAISEES", RAISEES);
  EnterNodeToBoolProc("RANGE_EXP", RANGE_EXP);
  EnterNodeToBoolProc("EXP", EXP);
  EnterNodeToBoolProc("NUMERIC_LITERAL", NUMERIC_LITERAL);
  EnterNodeToBoolProc("CONS_ELEM", CONS_ELEM);
  EnterNodeToBoolProc("RANGE_EXP_elem", RANGE_EXP_elem);
  EnterNodeToBoolProc("BINARY_OP", BINARY_OP);
  EnterNodeToBoolProc("UNARY_OP", UNARY_OP);
  EnterNodeToBoolProc("STM", STM);
  EnterNodeToBoolProc("STM_WSS", STM_WSS);
  EnterNodeToBoolProc("SUBSTM_WSS", SUBSTM_WSS);
  EnterNodeToBoolProc("TRY_TAIL", TRY_TAIL);

  EnterNodeToBoolProc("Module_id", Module_id);
  EnterNodeToBoolProc("Interface_id", Interface_id);
  EnterNodeToBoolProc("Interface_AS_id", Interface_AS_id);
  EnterNodeToBoolProc("F_Interface_id", F_Interface_id);
  EnterNodeToBoolProc("F_Value_id", F_Value_id);
  EnterNodeToBoolProc("F_Var_id", F_Var_id);
  EnterNodeToBoolProc("F_Readonly_id", F_Readonly_id);
  EnterNodeToBoolProc("Type_id", Type_id);
  EnterNodeToBoolProc("Const_id", Const_id);
  EnterNodeToBoolProc("Var_id", Var_id);
  EnterNodeToBoolProc("Proc_id", Proc_id);
  EnterNodeToBoolProc("Enum_id", Enum_id);
  EnterNodeToBoolProc("Method_id", Method_id);
  EnterNodeToBoolProc("Override_id", Override_id);
  EnterNodeToBoolProc("Field_id", Field_id);
  EnterNodeToBoolProc("For_id", For_id);
  EnterNodeToBoolProc("Handler_id", Handler_id);
  EnterNodeToBoolProc("Tcase_id", Tcase_id);
  EnterNodeToBoolProc("With_id", With_id);
  EnterNodeToBoolProc("Exc_id", Exc_id);
  EnterNodeToBoolProc("Used_interface_id", Used_interface_id);
  EnterNodeToBoolProc("Used_def_id", Used_def_id);
  EnterNodeToBoolProc("Qual_used_id", Qual_used_id);
  EnterNodeToBoolProc("Compilation_Unit", Compilation_Unit);
  EnterNodeToBoolProc("Interface_gen_def", Interface_gen_def);
  EnterNodeToBoolProc("Module_gen_def", Module_gen_def);
  EnterNodeToBoolProc("Interface", Interface);
  EnterNodeToBoolProc("Module", Module);
  EnterNodeToBoolProc("Module_gen_ins", Module_gen_ins);
  EnterNodeToBoolProc("Interface_gen_ins", Interface_gen_ins);
  EnterNodeToBoolProc("Unsafe", Unsafe);
  EnterNodeToBoolProc("Simple_import", Simple_import);
  EnterNodeToBoolProc("From_import", From_import);
  EnterNodeToBoolProc("Import_item", Import_item);
  EnterNodeToBoolProc("Revelation_s", Revelation_s);
  EnterNodeToBoolProc("Const_decl_s", Const_decl_s);
  EnterNodeToBoolProc("Type_decl_s", Type_decl_s);
  EnterNodeToBoolProc("Var_decl_s", Var_decl_s);
  EnterNodeToBoolProc("Exc_decl_s", Exc_decl_s);
  EnterNodeToBoolProc("Proc_decl", Proc_decl);
  EnterNodeToBoolProc("Const_decl", Const_decl);
  EnterNodeToBoolProc("Var_decl", Var_decl);
  EnterNodeToBoolProc("Exc_decl", Exc_decl);
  EnterNodeToBoolProc("Subtype_decl", Subtype_decl );
  EnterNodeToBoolProc("Concrete_decl", Concrete_decl);
  EnterNodeToBoolProc("Subtype_reveal", Subtype_reveal );
  EnterNodeToBoolProc("Concrete_reveal", Concrete_reveal);
  EnterNodeToBoolProc("Named_type", Named_type);
  EnterNodeToBoolProc("Integer_type", Integer_type);
  EnterNodeToBoolProc("Real_type", Real_type);
  EnterNodeToBoolProc("LongReal_type", LongReal_type);
  EnterNodeToBoolProc("Extended_type", Extended_type);
  EnterNodeToBoolProc("Null_type", Null_type);
  EnterNodeToBoolProc("RefAny_type", RefAny_type);
  EnterNodeToBoolProc("Address_type", Address_type);
  EnterNodeToBoolProc("Root_type", Root_type);
  EnterNodeToBoolProc("Enumeration_type", Enumeration_type);
  EnterNodeToBoolProc("Subrange_type", Subrange_type);
  EnterNodeToBoolProc("Array_type", Array_type);
  EnterNodeToBoolProc("Record_type", Record_type);
  EnterNodeToBoolProc("Object_type", Object_type);
  EnterNodeToBoolProc("Set_type", Set_type);
  EnterNodeToBoolProc("Procedure_type", Procedure_type);
  EnterNodeToBoolProc("Ref_type", Ref_type);
  EnterNodeToBoolProc("Packed_type", Packed_type);
  EnterNodeToBoolProc("Opaque_type", Opaque_type);
  EnterNodeToBoolProc("Brand", Brand);
  EnterNodeToBoolProc("Untraced", Untraced);
  EnterNodeToBoolProc("Fields", Fields);
  EnterNodeToBoolProc("Method", Method);
  EnterNodeToBoolProc("Override", Override);
  EnterNodeToBoolProc("Formal_param", Formal_param);
  EnterNodeToBoolProc("Raisees_some", Raisees_some);
  EnterNodeToBoolProc("Raisees_any", Raisees_any);
  EnterNodeToBoolProc("Range_EXP", Range_EXP);
  EnterNodeToBoolProc("Range", Range);
  EnterNodeToBoolProc("Integer_literal", Integer_literal);
  EnterNodeToBoolProc("Real_literal", Real_literal);
  EnterNodeToBoolProc("LongReal_literal", LongReal_literal);
  EnterNodeToBoolProc("Extended_literal", Extended_literal);
  EnterNodeToBoolProc("Text_literal", Text_literal);
  EnterNodeToBoolProc("Char_literal", Char_literal);
  EnterNodeToBoolProc("Nil_literal", Nil_literal);
  EnterNodeToBoolProc("Exp_used_id", Exp_used_id);
  EnterNodeToBoolProc("Constructor", Constructor);
  EnterNodeToBoolProc("Actual_elem", Actual_elem);
  EnterNodeToBoolProc("Propagate", Propagate);
  EnterNodeToBoolProc("Binary", Binary);
  EnterNodeToBoolProc("Plus", Plus);
  EnterNodeToBoolProc("Minus", Minus);
  EnterNodeToBoolProc("Times", Times);
  EnterNodeToBoolProc("Rdiv", Rdiv);
  EnterNodeToBoolProc("Textcat", Textcat);
  EnterNodeToBoolProc("Div", Div);
  EnterNodeToBoolProc("Mod", Mod);
  EnterNodeToBoolProc("Eq", Eq);
  EnterNodeToBoolProc("Ne", Ne);
  EnterNodeToBoolProc("Gt", Gt);
  EnterNodeToBoolProc("Lt", Lt);
  EnterNodeToBoolProc("Ge", Ge);
  EnterNodeToBoolProc("Le", Le);
  EnterNodeToBoolProc("And", And);
  EnterNodeToBoolProc("Or", Or);
  EnterNodeToBoolProc("In", In);
  EnterNodeToBoolProc("Select", Select);
  EnterNodeToBoolProc("Unary", Unary);
  EnterNodeToBoolProc("Not", Not);
  EnterNodeToBoolProc("Unaryplus", Unaryplus);
  EnterNodeToBoolProc("Unaryminus", Unaryminus);
  EnterNodeToBoolProc("Deref", Deref);
  EnterNodeToBoolProc("Call", Call);
  EnterNodeToBoolProc("Index", Index);
  EnterNodeToBoolProc("Actual", Actual);
  EnterNodeToBoolProc("Assign_st", Assign_st);
  EnterNodeToBoolProc("Call_st", Call_st);
  EnterNodeToBoolProc("Case_st", Case_st);
  EnterNodeToBoolProc("Eval_st", Eval_st);
  EnterNodeToBoolProc("Exit_st", Exit_st);
  EnterNodeToBoolProc("For_st", For_st);
  EnterNodeToBoolProc("If_st", If_st);
  EnterNodeToBoolProc("Lock_st", Lock_st);
  EnterNodeToBoolProc("Loop_st", Loop_st);
  EnterNodeToBoolProc("Raise_st", Raise_st);
  EnterNodeToBoolProc("Repeat_st", Repeat_st);
  EnterNodeToBoolProc("Return_st", Return_st);
  EnterNodeToBoolProc("Try_st", Try_st);
  EnterNodeToBoolProc("Typecase_st", Typecase_st);
  EnterNodeToBoolProc("While_st", While_st);
  EnterNodeToBoolProc("With_st", With_st);
  EnterNodeToBoolProc("Block", Block);
  EnterNodeToBoolProc("Case", Case);
  EnterNodeToBoolProc("Else_stm", Else_stm);
  EnterNodeToBoolProc("Elsif", Elsif);
  EnterNodeToBoolProc("Try_except", Try_except);
  EnterNodeToBoolProc("Try_finally", Try_finally);
  EnterNodeToBoolProc("Tcase", Tcase);
  EnterNodeToBoolProc("Handler", Handler);
  EnterNodeToBoolProc("Binding", Binding);
  EnterNodeToBoolProc("By", By);
  EnterNodeToBoolProc("Bad_EXP", Bad_EXP);
  EnterNodeToBoolProc("Bad_M3TYPE", Bad_M3TYPE);
  EnterNodeToBoolProc("Bad_STM", Bad_STM);

  EnterNodeToBoolProc("Void_type", Void_type );
  EnterNodeToBoolProc("INIT_ID", INIT_ID );
  EnterNodeToBoolProc("CCV_ID", CCV_ID );
  EnterNodeToBoolProc("REDEF_ID", REDEF_ID );
  EnterNodeToBoolProc("RECOBJ_ID", RECOBJ_ID );

  EnterNodeToNodeProc("as_intf_id", as_intf_id);
  EnterNodeToNodeProc("as_id", as_id);
  EnterNodeToNodeProc("as_root", as_root);
  EnterNodeToNodeProc("as_import_s", as_import_s );
  EnterNodeToNodeProc("as_block", as_block);
  EnterNodeToNodeProc("as_id_s", as_id_s );
  EnterNodeToNodeProc("as_unsafe", as_unsafe);
  EnterNodeToNodeProc("as_export_s", as_export_s );
  EnterNodeToNodeProc("as_unsafe", as_unsafe);
  EnterNodeToNodeProc("as_gen_id", as_gen_id);
  EnterNodeToNodeProc("as_import_item_s", as_import_item_s );
  EnterNodeToNodeProc("as_reveal_s", as_reveal_s );
  EnterNodeToNodeProc("as_const_decl_s", as_const_decl_s );
  EnterNodeToNodeProc("as_type_decl_s", as_type_decl_s );
  EnterNodeToNodeProc("as_var_decl_s", as_var_decl_s );
  EnterNodeToNodeProc("as_exc_decl_s", as_exc_decl_s );
  EnterNodeToNodeProc("as_type", as_type);
  EnterNodeToNodeProc("as_exp", as_exp);
  EnterNodeToNodeProc("as_default", as_default);
  EnterNodeToNodeProc("as_body", as_body);
  EnterNodeToNodeProc("as_qual_id", as_qual_id);
  EnterNodeToNodeProc("as_trace_mode", as_trace_mode);
  EnterNodeToNodeProc("as_indextype_s", as_indextype_s );
  EnterNodeToNodeProc("as_elementtype", as_elementtype);
  EnterNodeToNodeProc("as_range", as_range);
  EnterNodeToNodeProc("as_fields_s", as_fields_s );
  EnterNodeToNodeProc("as_brand", as_brand);
  EnterNodeToNodeProc("as_trace_mode", as_trace_mode);
  EnterNodeToNodeProc("as_ancestor", as_ancestor);
  EnterNodeToNodeProc("as_fields_s", as_fields_s );
  EnterNodeToNodeProc("as_method_s", as_method_s );
  EnterNodeToNodeProc("as_override_s", as_override_s );
  EnterNodeToNodeProc("as_formal_param_s", as_formal_param_s );
  EnterNodeToNodeProc("as_result_type", as_result_type);
  EnterNodeToNodeProc("as_raises", as_raises);
  EnterNodeToNodeProc("as_formal_type", as_formal_type);
  EnterNodeToNodeProc("as_raisees_s", as_raisees_s );
  EnterNodeToNodeProc("as_exp1", as_exp1);
  EnterNodeToNodeProc("as_exp2", as_exp2);
  EnterNodeToNodeProc("as_element_s", as_element_s );
  EnterNodeToNodeProc("as_propagate", as_propagate);
  EnterNodeToNodeProc("as_range_exp", as_range_exp);
  EnterNodeToNodeProc("as_actual", as_actual);
  EnterNodeToNodeProc("as_binary_op", as_binary_op);
  EnterNodeToNodeProc("as_unary_op", as_unary_op);
  EnterNodeToNodeProc("as_callexp", as_callexp);
  EnterNodeToNodeProc("as_param_s", as_param_s );
  EnterNodeToNodeProc("as_exp_type", as_exp_type);
  EnterNodeToNodeProc("as_array", as_array);
  EnterNodeToNodeProc("as_exp_s", as_exp_s );
  EnterNodeToNodeProc("as_stm_s", as_stm_s );
  EnterNodeToNodeProc("as_lhs_exp", as_lhs_exp);
  EnterNodeToNodeProc("as_rhs_exp", as_rhs_exp);
  EnterNodeToNodeProc("as_call", as_call);
  EnterNodeToNodeProc("as_case_s", as_case_s );
  EnterNodeToNodeProc("as_else", as_else);
  EnterNodeToNodeProc("as_case_label_s", as_case_label_s );
  EnterNodeToNodeProc("as_from", as_from);
  EnterNodeToNodeProc("as_to", as_to);
  EnterNodeToNodeProc("as_by", as_by);
  EnterNodeToNodeProc("as_elsif_s", as_elsif_s );
  EnterNodeToNodeProc("as_qual_id", as_qual_id);
  EnterNodeToNodeProc("as_exp_void", as_exp_void);
  EnterNodeToNodeProc("as_try_tail", as_try_tail);
  EnterNodeToNodeProc("as_handler_s", as_handler_s );
  EnterNodeToNodeProc("as_qual_id_s", as_qual_id_s );
  EnterNodeToNodeProc("as_tcase_s", as_tcase_s );
  EnterNodeToNodeProc("as_type_s", as_type_s );
  EnterNodeToNodeProc("as_binding_s", as_binding_s );
  EnterNodeToNodeProc("as_decl_s", as_decl_s );

  EnterNodeToNodeProc("sm_import_s", sm_import_s );
  EnterNodeToNodeProc("sm_ins_comp_unit", sm_ins_comp_unit);
  EnterNodeToNodeProc("sm_spec", sm_spec);
  EnterNodeToNodeProc("sm_export_s", sm_export_s );
  EnterNodeToNodeProc("sm_concrete_proc_id", sm_concrete_proc_id);
  EnterNodeToNodeProc("sm_def", sm_def);
  EnterNodeToNodeProc("sm_type_spec", sm_type_spec);
  EnterNodeToNodeProc("sm_concrete_type_spec", sm_concrete_type_spec);
  EnterNodeToNodeProc("sm_type_spec_s", sm_type_spec_s );
  EnterNodeToNodeProc("sm_type_spec", sm_type_spec);
  EnterNodeToNodeProc("sm_base_type_spec", sm_base_type_spec);
  EnterNodeToNodeProc("sm_def_id", sm_def_id);
  EnterNodeToIntProc("sm_bitsize", sm_bitsize );
  EnterNodeToIntProc("sm_align", sm_align );
  EnterNodeToIntProc("sm_rf_bitsize", sm_rf_bitsize );
  EnterNodeToIntProc("sm_rf_align", sm_rf_align );
  EnterNodeToNodeProc("sm_exp_type_spec", sm_exp_type_spec);
  EnterNodeToNodeProc("sm_actual_s", sm_actual_s );
  EnterNodeToNodeProc("sm_int_def", sm_int_def);
  EnterNodeToNodeProc("sm_init_exp", sm_init_exp);
  EnterNodeToNodeProc("sm_def", sm_def);
  EnterNodeToNodeProc("sm_unit_id", sm_unit_id);
END M3ASTQueryImpl.









