MODULE M3Extension;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

(* Version which support DEC SRC Modula-3 extensions *)

IMPORT Text;
IMPORT PathName, HashText;


VAR
  exts_g: HashText.Table;

CONST
  Deprecated = TSet{T.Obj, T.C, T.Asm};

PROCEDURE ToText(t: T): Text.T RAISES {} =
  BEGIN
    CASE t OF
      T.Int =>   RETURN "i3";
    | T.IntG => RETURN "ig";
    | T.IntPp =>   RETURN "i3p";
    | T.PInt =>  RETURN "pi";
    | T.Mod =>   RETURN "m3";
    | T.ModG => RETURN "mg";
    | T.ModPp =>   RETURN "m3p";
    | T.PMod =>  RETURN "pm";
    | T.PModR => RETURN "pmr";
    | T.PIntR => RETURN "pir";
    | T.IObj => RETURN "io";
    | T.MObj, T.Obj => RETURN "mo";
    | T.Exe => RETURN "out";
    | T.C, T.MC => RETURN "mc";
    | T.IC => RETURN "ic";
    | T.Asm, T.MAsm => RETURN "ms";
    | T.IAsm => RETURN "is";
    | T.Tmp =>  RETURN "tmp";
    | T.ObjLib => RETURN "a";
    | T.Null => RETURN "";
    END;
  END ToText;



PROCEDURE FromText(text: Text.T; VAR t: T): BOOLEAN RAISES {} =
  VAR
    id: HashText.Id;
  BEGIN
    IF HashText.Lookup(exts_g, text, id) THEN
      t := NARROW(HashText.Value(exts_g, id), REF T)^;
      RETURN TRUE;
    ELSE
      RETURN FALSE;
    END;
  END FromText;


PROCEDURE Extend(name: Text.T; t: T): Text.T RAISES {} =
  BEGIN
    RETURN PathName.Extend(name, ToText(t));
  END Extend;


PROCEDURE Has(
    name: Text.T;
    VAR t: T)
    : BOOLEAN
    RAISES {}=
  BEGIN
    RETURN FromText(PathName.Extension(name), t);
  END Has;

EXCEPTION Fatal;

PROCEDURE Init() RAISES {}=
  VAR
    id: HashText.Id;
  BEGIN
    FOR i := FIRST(T) TO LAST(T) DO
     IF NOT (i IN Deprecated) THEN
      IF HashText.Enter(exts_g, ToText(i), id) THEN
        HashText.Associate(exts_g, id, NewRefT(i));
      ELSE
        RAISE Fatal;
      END;
     END;
    END; (* for *)
  END Init;

PROCEDURE NewRefT(t: T): REF T RAISES {}=
  VAR
    r: REF T;
  BEGIN
    r := NEW(REF T);
    r^ := t;
    RETURN r;    
  END NewRefT;


BEGIN
  exts_g := HashText.New();
  Init();
END M3Extension.




