MODULE M3Files EXPORTS M3Files, M3Files_m3p;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT
  PathNameStream, IO, M3Extension, M3FindFile, M3Path, Text;

VAR
  finder_g: M3FindFile.T := NIL;

(*PUBLIC*)
PROCEDURE Open(
    name: Text.T;
    ext: M3Extension.T;
    mode: IO.OpenMode)
    : IO.Stream
    RAISES {IO.Error} =
(* open the file corresponding to module 'name' with m3 extension 'ext'. Open
 * with the given stream mode. Return the resulting stream.
 *)
  VAR
    fullName := M3Extension.Extend(name, ext);
  BEGIN
    CASE mode OF
    | IO.OpenMode.Read =>
        IF finder_g = NIL THEN
          finder_g := M3Path.Find( (* may raise IO.Error, BadDirName *)
              M3Extension.TSet{FIRST(M3Extension.T)..LAST(M3Extension.T)});
        END;
        TRY fullName := finder_g.find(name, ext)
        EXCEPT M3FindFile.Failed => RETURN NIL; (* no such file *)
        END;
        RETURN PathNameStream.Open(fullName, mode); (* may raise IO.Error *)
    | IO.OpenMode.Write, IO.OpenMode.Append, IO.OpenMode.Update,
      IO.OpenMode.WriteAndRead, IO.OpenMode.AppendAndRead =>
        RETURN PathNameStream.Open(fullName, mode);
    END; (*case*)
  END Open;

PROCEDURE GetFinder(): M3FindFile.T RAISES {}=
  BEGIN
    RETURN finder_g
  END GetFinder;

PROCEDURE SetFinder(f: M3FindFile.T) RAISES {}=
  BEGIN
    finder_g := f;
  END SetFinder;


BEGIN
  M3Path.EnsureCurrentFirst();
END M3Files.
