INTERFACE AST_CopyRep;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

(* Clients must not apply the 'copy' method directly, but use the ASTCopy
   interface instead. New AST nodes must provide an implementation of the 
   'copy' method.
*)

IMPORT AST, AST_WalkRep;

TYPE
  NODE = AST_WalkRep.NODE OBJECT
    METHODS
      copy(handle: Handle): AST.NODE RAISES ANY := Null;
      (* Return a copy of the tree rooted at 'self'.
      The concrete method defines precisely which attributes are copied. *)
    END;

REVEAL AST.NODE <: NODE;

TYPE
  Handle <: Handle_public;
  Handle_public = OBJECT
    METHODS
      Copy(n: AST.NODE): AST.NODE RAISES ANY;
  END;


PROCEDURE Null(n: NODE; handle: Handle): AST.NODE RAISES {};
(* returns NIL; used as default method *)

END AST_CopyRep.
