(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* This interface adds methods to iterate the children of a node
without regard for their static type, and to update a specific
child to a new value. The concrete methods define the order in
which children are returned. *)

INTERFACE AST_Iter;

IMPORT AST, AST_Name;

TYPE 
  NODE = AST_Name.NODE OBJECT
    METHODS
      newIter(): T RAISES {} := Null;
      (* create an iterator for the children of this node. The iterator
         provides a 'next' method. *)
      update(iter: T; nn: AST.NODE) RAISES {} := NullUpdate;
      (* if 'iter.next(r)' would return TRUE, replace the child
         (which currently has value 'r') with 'nn', else a checked
         run-time error. No actual call of 'next' takes place. 
       *)
  END;

PROCEDURE Null(n: NODE):T RAISES {};
(* returns a value which always returns FALSE on a call of 'next'. *)

PROCEDURE NullUpdate(n: NODE; iter: T; nn: AST.NODE) RAISES {};
(* just returns *)

REVEAL AST.NODE <: NODE;
  
TYPE
  T <: T_public;
  T_public = OBJECT
  METHODS
    next(VAR (*out*) n: AST.NODE): BOOLEAN RAISES {};
    (* return FALSE if there are no more children of this node
       else set 'n' to the next child, step the iterator, and
       return TRUE. *)
  END;

END AST_Iter.
