INTERFACE M3ASTCacheTool;

(* Copyright (C) 1991, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

IMPORT M3Args;

CONST
  ASTCache_Arg = "ASTCache";
  NotifyGC_Arg = "NotifyGC";
  DisableGC_Arg = "DisableGC";
  DiscardModules_Arg = "DiscardModules";

PROCEDURE Check() RAISES {};
(* Check for the above arguments and initialise accordingly *)

PROCEDURE Handle(): M3Args.T RAISES {};
(* return the tool handle *)

PROCEDURE Current(): CARDINAL RAISES {};
(* return the current pre-allocated memory amount *)

PROCEDURE Increase(n: CARDINAL): CARDINAL RAISES {};
(* allocate an additional 'n' bytes of heap, then return 'Current()' *)

PROCEDURE Notify(b: BOOLEAN) RAISES {};
(* set the notification state according to 'b' *)

END M3ASTCacheTool.
