MODULE ReadGraph;

IMPORT Algorithm, AdjMatrix, FileStream, FormsVBT, Rd, VBT;

PROCEDURE In(alg: Algorithm.T): AdjMatrix.T RAISES {}=
  VAR
    graphDataFile: TEXT;
    rd: Rd.T;
  BEGIN
    LOCK VBT.mu DO
      graphDataFile := FormsVBT.GetText(alg.data, "graphdata");
    END;
    rd := FileStream.OpenRead(graphDataFile);
    RETURN NEW(AdjMatrix.T).initFromRd(rd);
  END In;

BEGIN

END ReadGraph.
