(* Copyright 1992 Digital Equipment Corporation. *)
(* Distributed only by permission. *)

MODULE PQueue;

IMPORT Fmt, List, Thread, MGPublic;

REVEAL
  WorkQueue = WorkQueuePublic BRANDED OBJECT
  OVERRIDES
    addElement := AddElement;
    removeElement := RemoveElement;
    isEmpty := IsEmpty;
  END;

PROCEDURE PrintHeap(heap: REF ARRAY OF INTEGER): TEXT =
  VAR result:= "";
  BEGIN
   FOR i := 1 TO LAST(heap^) DO
     result := result & Fmt.Int(heap[i])& " ";
   END;
   RETURN result;
  END PrintHeap;

PROCEDURE AddElement(wq: WorkQueue; op: QueueOp; p1: INTEGER :=0) =
  VAR refOp := NEW(REF QueueOp);
      refp1 := NEW(REF INTEGER);
  BEGIN
    refOp^ := op;  refp1^ := p1;
    LOCK wq DO
      wq.q := List.Append1(wq.q, List.List2(refOp, refp1));
      Thread.Broadcast(wq.c);
    END;
  END AddElement;

PROCEDURE RemoveElement(wq: WorkQueue) : List.T RAISES {Thread.Alerted} =
  BEGIN
    LOCK wq DO
      WHILE List.Length(wq.q) = 0 DO
        Thread.AlertWait(wq, wq.c);
      END;
      RETURN List.Pop(wq.q);
    END;
  END RemoveElement;

PROCEDURE IsEmpty(wq: WorkQueue) : BOOLEAN =
  BEGIN
    LOCK wq DO
      RETURN (List.Length(wq.q) = 0);
    END;
  END IsEmpty;

BEGIN
  StartColor := MGPublic.OpFromName("Orchid");
  SortedColor := MGPublic.OpFromName("RatherDarkOrchid");
  WorkColor := MGPublic.OpFromName("RatherPaleOrchid");
  HighlightColor := MGPublic.OpFromName("Turquoise");
  NotInHeapEdgeColor := MGPublic.OpFromName("PaleGray");
  Black := MGPublic.OpFromName("Black");
  White := MGPublic.OpFromName("White");
END PQueue.
