(* Test: the Fmt interface *)

MODULE Main;

IMPORT Fmt;
FROM Wr IMPORT PutText, Close;
FROM Stdio IMPORT stdout;
FROM Fmt IMPORT Style, Align;
<*FATAL ANY*>

BEGIN

PutText (stdout, "true  = " & Fmt.Bool (TRUE) & "\n");
PutText (stdout, "false = " & Fmt.Bool (FALSE) & "\n\n");

PutText (stdout, "0    = " & Fmt.Int (0) & "\n");
PutText (stdout, "179  = " & Fmt.Int (179) & "\n");
PutText (stdout, "-83  = " & Fmt.Int (-83) & "\n");
PutText (stdout, "1000 = " & Fmt.Int (1000) & "\n\n");

PutText (stdout, "(5) 179  = " & Fmt.Int (179, 5) & "\n");
PutText (stdout, "(5) -83  = " & Fmt.Int (-83, 5) & "\n");
PutText (stdout, "(5) 1000 = " & Fmt.Int (1000, 5) & "\n\n");

PutText (stdout, "12.34, 6, Flo    = " & Fmt.Real (12.34, 6, Style.Flo) & "\n");
PutText (stdout, "12.34, 6, AltFlo = " & Fmt.Real (12.34, 6, Style.AltFlo) & "\n");
PutText (stdout, "12.34, 6, Sci    = " & Fmt.Real (12.34, 6, Style.Sci) & "\n");
PutText (stdout, "12.34, 6, AltSci = " & Fmt.Real (12.34, 6, Style.AltSci) & "\n");
PutText (stdout, "12.34, 6, Mix    = " & Fmt.Real (12.34, 6, Style.Mix) & "\n\n");


PutText (stdout, "12.34, 1, Flo    = " & Fmt.Real (12.34, 1, Style.Flo) & "\n");
PutText (stdout, "12.34, 1, AltFlo = " & Fmt.Real (12.34, 1, Style.AltFlo) & "\n");
PutText (stdout, "12.34, 1, Sci    = " & Fmt.Real (12.34, 1, Style.Sci) & "\n");
PutText (stdout, "12.34, 1, AltSci = " & Fmt.Real (12.34, 1, Style.AltSci) & "\n");
PutText (stdout, "12.34, 1, Mix    = " & Fmt.Real (12.34, 1, Style.Mix)
& "\n\n");

PutText (stdout, "178.3456E-23, 6, Flo    = " & Fmt.Real (178.3456E-23, 6, Style.Flo) & "\n");
PutText (stdout, "178.3456E-23, 6, AltFlo = " & Fmt.Real (178.3456E-23, 6, Style.AltFlo) & "\n");
PutText (stdout, "178.3456E-23, 6, Sci    = " & Fmt.Real (178.3456E-23, 6, Style.Sci) & "\n");
PutText (stdout, "178.3456E-23, 6, AltSci = " & Fmt.Real (178.3456E-23, 6, Style.AltSci) & "\n");
PutText (stdout, "178.3456E-23, 6, Mix    = " & Fmt.Real (178.3456E-23, 6, Style.Mix) & "\n\n");

PutText (stdout, "178.3456E-23, 1, Flo    = " & Fmt.Real (178.3456E-23, 1, Style.Flo) & "\n");
PutText (stdout, "178.3456E-23, 1, AltFlo = " & Fmt.Real (178.3456E-23, 1, Style.AltFlo) & "\n");
PutText (stdout, "178.3456E-23, 1, Sci    = " & Fmt.Real (178.3456E-23, 1, Style.Sci) & "\n");
PutText (stdout, "178.3456E-23, 1, AltSci = " & Fmt.Real (178.3456E-23, 1, Style.AltSci) & "\n");
PutText (stdout, "178.3456E-23, 1, Mix    = " & Fmt.Real (178.3456E-23,
1, Style.Mix) & "\n\n");

PutText (stdout, "z = " & Fmt.Char ('z') & "\n\n");

PutText (stdout, "++++zzzz = " & Fmt.Pad ("zzzz", 8, '+', Align.Right) & "\n");
PutText (stdout, "zzzz++++ = " & Fmt.Pad ("zzzz", 8, '+', Align.Left) & "\n");
PutText (stdout, "+aaaaaaa = " & Fmt.Pad ("aaaaaaa", 8, '+', Align.Right) & "\n");
PutText (stdout, "aaaaaaaa = " & Fmt.Pad ("aaaaaaaa", 8, '+', Align.Right) & "\n");
PutText (stdout, "aaaaaaaa = " & Fmt.Pad ("aaaaaaaa", 3, '+', Align.Right) & "\n");

PutText (stdout, "\ndone.\n");
Close (stdout);

END Main.
