(* Last modified on Mon Oct 26 11:08:15 PST 1992 by kalsow  *)
(*      modified on Tue Dec 17  9:05:34 PST 1991 by mcjones *)
(*      modified on Mon Aug  6 20:17:50 PDT 1990 by ellis   *)
(*      modified on Tue May  1 23:11:02 1990 by saxe        *)

UNSAFE MODULE Main;
IMPORT Test, Word;

(* Bit operations *)

TYPE
  Bit = [0 .. 31];
  BitSet = (*BITS 32 FOR*) SET OF Bit;
  (* BitVector = BITS 32 FOR ARRAY Bit OF BITS 1 FOR BOOLEAN;*)

VAR
  i, j, k: INTEGER;
  ar: ARRAY [0 .. 58] OF INTEGER;

BEGIN
  FOR ind1 := 0 TO 58 DO
    ar[ind1] := ROUND (FLOAT(LAST(INTEGER), LONGREAL)
                         * (FLOAT(ind1, LONGREAL) / 58.0d0));
  END;

  FOR ind1 := 0 TO 56 DO
    j := ar[ind1 + 2] - ar[ind1 + 1];
    k := ar[ind1 + 1] - ar[ind1];
    Test.check (j <= k + 1);
    Test.check (k <= j + 1);
  END;

  FOR ind1 := 0 TO 58 DO
    i := ar[ind1];
    Test.checkI (i + Word.Not(i), Word.Not (0));
    Test.checkI (Word.Shift(i,200), 0);
    Test.checkI (Word.Rotate(i,100), Word.Rotate(i,4));
    Test.checkI (Word.Rotate(i,100), Word.Rotate(i,-3100));
    Test.checkI (Word.Rotate(i,100), Word.Rotate(i,-3100));

    FOR bit := 0 TO 30 DO
      Test.checkI (Word.Shift(i,-bit), i DIV Word.Shift(1,bit));
    END;

    FOR bit := 0 TO 31 DO
      Test.checkI (i, 
        Word.Rotate(Word.Shift(i,-bit)+Word.Shift(i,32-bit),bit));
      Test.checkI (Word.Rotate(i,-27*bit), Word.Rotate(i,5*bit));
    END;

    FOR ind2 := 0 TO 58 DO
      j := ar[ind2];

      k := Word.And (i, j);
      Test.check (k <= i);
      Test.check (k <= j);
      Test.check (LOOPHOLE(k,BitSet) = LOOPHOLE(j,BitSet)*LOOPHOLE(i,BitSet));
      FOR bit := 0 TO 31 DO
        Test.checkB (
          (bit IN LOOPHOLE(k, BitSet)),
         ((bit IN LOOPHOLE(i, BitSet)) AND (bit IN LOOPHOLE(j, BitSet))));
        (************
        Test.checkB (
          LOOPHOLE(k, BitVector)[bit],
         (LOOPHOLE(j, BitVector)[bit] AND LOOPHOLE(i, BitVector)[bit]));
        ************)
      END;

      k := Word.Or (i, j);
      Test.check (k >= i);
      Test.check (k >= j);
      Test.check (LOOPHOLE(k,BitSet) = LOOPHOLE(j,BitSet)+LOOPHOLE(i,BitSet));
      FOR bit := 0 TO 31 DO
        Test.checkB (
          (bit IN LOOPHOLE(k, BitSet)),
         ((bit IN LOOPHOLE(i, BitSet)) OR (bit IN LOOPHOLE(j, BitSet))));
        (************
        Test.checkB (
          LOOPHOLE(k, BitVector)[bit],
         (LOOPHOLE(j, BitVector)[bit] OR LOOPHOLE(i, BitVector)[bit]));
        ************)
      END;

      k := Word.Xor (i, j);
      Test.checkI (k, Word.Or (i,j) - Word.And (i,j));
      Test.check (LOOPHOLE(k,BitSet) = LOOPHOLE(j,BitSet)/LOOPHOLE(i,BitSet));
      FOR bit := 0 TO 31 DO
        Test.checkB (
          (bit IN LOOPHOLE(k, BitSet)),
         ((bit IN LOOPHOLE(i, BitSet)) # (bit IN LOOPHOLE(j, BitSet))));
        (************
        Test.checkB (
          LOOPHOLE(k, BitVector)[bit],
         (LOOPHOLE(j, BitVector)[bit] # LOOPHOLE(i, BitVector)[bit]));
        ************)
      END;
    END;
  END;

  Test.done ();
END Main.
