/* Copyright (C) 1989, Digital Equipment Corporation           */
/* All rights reserved.                                        */
/* See the file COPYRIGHT for a full description.              */

/* Last modified on Tue Oct 13 17:17:05 PDT 1992 by muller     */
/*      modified on Mon Feb 12 15:03:11 1990 by kalsow     */


extern etext;
extern edata;

#include "M3Runtime.h"

#include <stdio.h>
#include <sys/file.h>

extern char * getenv ();

/* We do not include marker.h here; indeed, we do not want this piece
   of code to be covered !! For the same reason, the marker is broken
   into pieces. */

char *marker1 = "<<<<";
char *marker3 = ">>>>";
char *marker2 = "Coverage 1.0";

_VOID exit (n)
    int n;
{
    report_coverage ();
    _cleanup ();
    _exit (n);
}

report_coverage ()
{
  int *l, *start;
  char *output_file_name;
  int output_file;
  int i;
  int state;
  int marker2_len = strlen (marker2);
  int marker2_ilen = marker2_len / sizeof (int);

  /* open the output file */
  output_file_name = getenv ("COVERAGE_DATABASE");
  if (output_file_name == NULL) output_file_name = "coverage.out";
  output_file = open (output_file_name, O_WRONLY | O_APPEND | O_CREAT, 0644);
  if (output_file == -1) {
    fprintf (stderr, "coverage: cannot report coverage to %s\n",
             output_file_name);
    exit (1); }

  /* get an aligned pointer to the data segment */
#ifdef mips
  i = 0x10000000;
#else
  i = (int) &etext; 
#endif
  i /= sizeof (int);  i *= sizeof (int);

  state = 0;  /* outside a segment */

  /* scan the global data segment */
  for (l = (int*)i;  l < (int*) &edata;  l++) {
    /* look for a header */
    if ((*l == *((int*)marker1))
       && (strncmp (l+1, marker2, marker2_len) == 0)) {
      /* we found the beginning of a segment */
      l += marker2_ilen + 1;
      state = 1;
      start = l;
    };

    /* look for a trailer */
    if ((*l == *((int*)marker3))
       && (strncmp (l-marker2_ilen, marker2, marker2_len) == 0)) {
      /* we found the end of a segment */
      if (state == 1) {
        /* write the segment */
	i = (l - marker2_ilen) - start;
	i *= sizeof (int);
	write (output_file, &i, sizeof (int));
	write (output_file, start, i);
      };
      state = 0;
      l++;
    };
  }; /* for */

  close (output_file);
}

