(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Mon Feb 24 13:50:52 PST 1992 by muller                   *)

INTERFACE RPCVBT;

IMPORT VBTProvider, RPC, Axis, Rect, Word, VBT, BatchUtil;

TYPE 
  Child = OBJECT METHODS 
    getCursor(): ScrnCursorT;
    axisOrder(): Axis.T;
    read
    write
    discard
    shape
    prod(READONLY ev: Event; startMessenger: BOOLEAN);
  END;
  Parent = OBJECT METHODS 
    setcage(READONLY cage: VBT.Cage; seqno: Word.T);
    setcursor(cs: ScrnCursorT);
    paint(
      READONLY batch: ARRAY OF Word.T;
      READONLY clip, scrollSource: Rect.T;
      clipState: BatchUtil.ClipState;
      seqno: Word.T);
    sync
    readUp
    writeUp
    capture
    screenOf
    newShape
    acquire
    release
    put
    forge
    paintAndGet(
      READONLY batch: ARRAY OF Word.T;
      READONLY clip, scrollSource: Rect.T;
      clipState: BatchUtil.ClipState;
      READONLY cage: VBT.Cage;
      seqno: Word.T): Event
      RAISES {Thread.Alerted, RPC.CallFailed};
    setCageAndPaint(
      READONLY batch: ARRAY OF Word.T;
      READONLY clip, scrollSource: Rect.T;
      clipState: BatchUtil.ClipState;
      READONLY cage: VBT.Cage;
      seqno: Word.T) RAISES {Thread.Alerted, RPC.CallFailed};
    setCageAndGet(READONLY cage: VBT.Cage; seqno: Word.T): Event
      RAISES {Thread.Alerted, RPC.CallFailed};
    getScreenType
    getBadRegion
  END;
  Connection = OBJECT METHODS
    apply(t: TEXT; prnt: Parent): Child 
    RAISES {VBTProvider.Error, RPC.CallFailed}
    <* LL = parent address space VBT.mu *>
  END;

TYPE 
  Event = RECORD
    type: EventType;
    whatButtonChanged: VBT.Button;
    time: VBT.TimeStamp;
    cp: VBT.CursorPosition;
    modifiers: VBT.Modifiers;
    clickType: VBT.ClickType;
    clickCount: INTEGER;
    new, saved, badRect: Rect.T;
    badRegionIsRect: BOOLEAN;  
    marked: BOOLEAN;
    miscType: VBT.MiscCodeType;
    detail: VBT.MiscCodeDetail;
    selection: VBT.SelectionOrNil;
    whatKeyChanged: VBT.KeySym;
    wentDown: BOOLEAN;
  END;
  EventType = {None, Mouse, Position, Redisplay, Reshape, Rescreen, 
    Repaint, Misc, Key}
  
(* An "Event" "e" represents the forwarding from parent to child of
   call to the VBT down method "e.type", unless "type" is "None", in
   which case the event directs the child address space to kill its
   messenger thread.  Only a subset of the remaining fields are
   relevant, as determined by the "VBT" interface; for example, in a
   "Position" event, only the "cp", "time", and "modifiers" fields are
   relevant.  The "whatChanged" fields of Button and Key events have
   been renamed into whatButtonChanged and whatKeyChanged, since they
   have different types.  In a "Repaint" event, the whole bad region
   is not transferred: instead the rectangle "badRect" is the bounding
   box of the bad region, and the boolean "badRegionIsRect" is "TRUE"
   if the badRegion equals the badRect.  The "prev" field of a
   "Rescreen" or "Reshape" event is not transferred, since it equals
   the child's domain.  The new screentype is not transferred with a
   "Rescreen" event; instead, the child calls the parent's getScreenType
   method to respond to the event.  *)
       
REVEAL VBTProvider.Remote = BRANDED OBJECT METHODS
    connect(): Connection
  END;
  
END RPCVBT.
