(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* by Steve Glassman, Mark Manasse and Greg Nelson           *)
(* Last modified on Mon Feb 24 13:57:40 PST 1992 by muller   *)
(*      modified on Sat Nov  2 17:21:17 PST 1991 by gnelson  *)
(*      modified on Wed Sep 11 15:23:24 PDT 1991 by msm      *)
<*PRAGMA LL*>

MODULE Pixmap;

IMPORT Palette, ScrnPixmap, ScreenType, TrestleComm;

EXCEPTION FatalError; <*FATAL FatalError*>

PROCEDURE FromBitmap(bits: Raw): T =
  BEGIN 
    IF bits.depth # 1 THEN RAISE FatalError END;
    RETURN Palette.FromPixmapClosure(NEW(Closure, bits := bits))
  END FromBitmap;

TYPE Closure = Palette.PixmapClosure OBJECT
    bits: Raw;
  OVERRIDES
    apply := Apply
  END;

PROCEDURE Apply(cl: Closure; st: ScreenType.T): ScrnPixmap.T =
  BEGIN
    TRY
      RETURN st.pixmap.load(cl.bits)
    EXCEPT
      TrestleComm.Failure => RETURN Palette.ResolvePixmap(st, Solid)
    END
  END Apply;
  
BEGIN END Pixmap.
