(* Copyright C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* by Steve Glassman, Mark Manasse and Greg Nelson *)
(* Last modified on Sat Nov  7 14:23:37 PST 1992 by msm *)
(* modified on Fri Jul 31 23:40:42 1992 by steveg *)
(* modified on Mon Feb 24 13:59:43 PST 1992 by muller *)
(* modified on Sat Jan 11 19:03:47 PST 1992 by gnelson*)


<*PRAGMA LL*>

(* Partitioning following the efforts of
   Steve.Freeman@computer-lab.cambridge.ac.uk - 92-05-13 *)

UNSAFE INTERFACE XClientF;

IMPORT XClient, TrestleOnX, TrestleClass, Trestle, Rect, ProperSplit,
       IntegerToRefanyTable, IntegerToTextTable, TextToIntegerTable, X,
       XEventQueue, Thread, XScreenType, VBT, Point, Ctypes, XScrollQueue,
       Region, TrestleComm;

REVEAL
  TrestleClass.RootVBT <: ProperSplit.T;
  TrestleOnX.Display <: T_Abs;

TYPE
  T_Abs <: T_Rel;
  T_Rel =
    XClient.T_Public OBJECT
      (* protection = self *)
      dead (*, hasMessenger, hasXFilter, hasSelectThread *) := FALSE;
      vbts : IntegerToRefanyTable.T;
      atoms: IntegerToTextTable.T;
      names: TextToIntegerTable.T;
      ungrab: ARRAY [0 .. 12] (*FIRST(Ungrab)..LAST(Ungrab)]*) OF X.KeyCode;
      sel: SelArray           := NIL;
      evq                     := XEventQueue.Empty;
      evc: Thread.Condition;
      (* signaled when evq.lo becomes different from evq.hi *)
      (* list of awaited events: *)
      qEmpty, qNonEmpty: Thread.Condition;
      (* qEmpty is signalled when the filterXInput thread discovers that
         the queue of events in Xlib is empty and wants the WaitForXInput
         thread to do a select on its behalf; qNonEmpty is signaled to
         alert the filterXInput thread that the queue in Xlib is non-empty,
         or that the error queue is non-empty. *)
      ooq := XEventQueue.Empty; (* The queue of out-of-order events -- such
                                   as MotionNotify from QueryPointer *)
      (*params: Trestle.Parameters;*)
      screens: REF ARRAY OF XScreenType.T;
      (* Types of the screens on the X server. *)
      defaultScreen: CARDINAL;
      (* index in screens of default screen for this X server. *)
      (* The next fields are protected by VBT.mu and self *)
      current, mouseFocus: VBT.T := NIL;
      (* The child that has received a FirstDown but no corresponding
         LastUp, or NIL if there is no such child. *)
      currentRoot, mouseFocusRoot := -1;
      (* If mouseFocus # NIL, mouseFocusRoot is the screen number of the
         root window containing it.  currentRoot is the screen number of
         the screen the cursor is on. *)
      currentRootWindow: X.Window := X.None;
      (* The root window of the current screen *)
      otherCages: BOOLEAN := FALSE;
      (* The remaining fields are protected by VBT.mu *)
      (* True if some VBT other than mouseFocus or current has a cage which
         fails to contain some point on currentRoot. *)
      takeFocus, deleteWindow, protocols, miscAtom, decTakeFocus, wmMoved,
        paNewScreen, paNewDisplay: X.Atom := X.None;
      errq                            := XEventQueue.Empty;
      eventHook: TrestleOnX.EventProc := NIL;
      (* protection = scheduler *)
    END;

TYPE
  Child = ProperSplit.Child OBJECT
            (* fields below protected by parent lock *)
            nwValid            := FALSE;
            nw     : Point.T;
            (* The nw field is the location of the northwest corner of the
               window on the root window, if nwValid is TRUE.*)
            inside := FALSE;
            (* whether the cursor is inside the window. *)
            mapped := FALSE;
            (* whether the X window is mapped. *)
            isXFocus, underXFocus := FALSE;
            (* The boolean isXFocus is true if this window has the X
               keyboard focus, and underXFocus is true if the X keyboard
               focus is an ancestor of this window. *)
            owns           : OwnsArray := NIL;
            recentlyOutside            := TRUE;
            (* true if the cursor has been outside our window since the
               last time a takefocus message was sent *)
            width, height: CARDINAL;
            (* width and height of X window. *)
            serial             : Ctypes.UnsignedLong;
            oldWidth, oldHeight                        := LAST(INTEGER);
            (* X exposure events that carry the given serial number and
               affect only the portion of the window outside of the old
               width and height can be discarded, since they are subsumed
               by a previous reshape. *)
            reshapeComing := FALSE;
            (* => a map, unmap, or configure event is in the parent's queue
               for this vbt. *)
            userPosition := FALSE;
            (* indicates whether the position to be set was generated
               by a user-specification in global coordinates *)
            w, xcage: X.Drawable;  (* xcage = X.None for offscreen VBTs *)
            cageRect: Rect.T;
            scrollQ                := XScrollQueue.Empty;
            (* The scroll queue contains the scrolling commands that have
               been issued but not yet acknowleged. *)
            badR := Region.Empty;
            (* The actual bad region of a Child ur is ur.badR union
               bad(ur.ch). *)
            sh, sv: VBT.SizeRange;
            (* The last hor and ver sizeranges that were reported to X. *)
            csid: X.Cursor;
            (* The last cursor id that was reported to X. *)
          END;

TYPE
  SelectionRecord = RECORD
                      v   : VBT.T         := NIL;
                      ts  : VBT.TimeStamp := 0;
                      name: X.Atom        := X.None
                    END;

  SelArray = REF ARRAY OF SelectionRecord;

  OwnsArray = REF ARRAY OF BOOLEAN;

TYPE
  NewScreenProp = REF RECORD
                        type, prop : X.Atom;
                        len, format: INTEGER;
                        data       : REF ARRAY OF Ctypes.char
                      END;

TYPE
  WaitFor =
    Thread.Condition OBJECT
      (* signalled when turn changes. *)
      ev     : X.XEvent;
      timeout: BOOLEAN;
      types               := ARRAY [0 .. 3] OF INTEGER{-1, ..};
      (* The types of events that this WaitFor might match, padded with
         -1s. *)
      (* remaining fields protected by the xcon containing this object in
         its await *)
      timelimit: INTEGER;
      (* -1 => no limit, else # of seconds until the waitfor times out. *)
      next: WaitFor := NIL;
      turn          := FALSE;
      (* FALSE => not yet matched; TRUE => matched and not yet processed *)
    METHODS
      match (READONLY ev: X.XEvent): BOOLEAN
    END;

  SimpleWaitForPublic =
    WaitFor OBJECT
      d: X.Drawable;
      (* d # X.None => non-error events must contain d in order to
         match. *)
      reqno: Ctypes.UnsignedLong;
      (* error events must contain this request no.  in order to match. *)
    END;

  SimpleWaitFor <: SimpleWaitForPublic;

PROCEDURE Kill (trsl: XClient.T);
<* LL.sup = trsl *>
(* clean way to close a Trestle *)

PROCEDURE Await (trsl: T_Abs; wf: WaitFor; timelimit: INTEGER := -1):
  INTEGER RAISES {TrestleComm.Failure};
<* LL.sup = trsl *>
(* Suspend execution of this thread until the timelimit expires, or until
   the WaitFor match method accepts an X event.  This routine releases trsl
   and regains it when the condition is met. *)

PROCEDURE FindWaiter (trsl: XClient.T; READONLY ev: X.XEvent): WaitFor;
<* LL.sup = trsl *>
(* Find a waiter which matches "ev" *)

(* ---------- various utilities ---------- *)
<* INLINE *> PROCEDURE ToRect (x, y, width, height: INTEGER): Rect.T;
(* utility to return a rectangle from X rectangle description *)

PROCEDURE NewAtom (v: XClient.T): X.Atom RAISES {TrestleComm.Failure};
PROCEDURE FreeAtom (v: XClient.T; VAR sym: X.Atom);

PROCEDURE BackDoor (v: XClient.T; READONLY ev: X.XEvent);
(* send an XEvent to the T *)

PROCEDURE SetUngrabs (trsl: XClient.T) RAISES {TrestleComm.Failure};

PROCEDURE ValidateNW (trsl: XClient.T; ch: Child; st: XScreenType.T)
  RAISES {TrestleComm.Failure};

PROCEDURE GetDomain (ur: Child; VAR (* OUT*) width, height: CARDINAL);
(* Return the domain of ur's X window, or 0,0 when the window is unmapped,
   and clear ur.reshapeComing.  LL = ur.ch.parent *)

PROCEDURE AdjustCoverage (xcon: XClient.T; d: [-1 .. 1] := 0)
  RAISES {TrestleComm.Failure};
(* see TrestleOnX.Enter() *)

PROCEDURE Delete (trsl: XClient.T; ch: VBT.T; ur: Child);

PROCEDURE Reshape (ch: VBT.T; width, height: CARDINAL; sendMoved := FALSE);
(* Reshape ch to new width and height.  LL = VBT.mu *)

(* ---------- connection management ---------- *)
PROCEDURE DoConnect (             self     : TrestleClass.ConnectClosure;
                                  inst     : TEXT;
                                  localOnly: BOOLEAN;
                     VAR (* OUT*) t        : Trestle.T                    ):
  BOOLEAN;
(* Apply procedure for TrestleClass.ConnectClosure.  Establishes connection
   with X server *)

END XClientF.
