(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Thu Jul 30 23:17:13 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 12:59:14 PDT 1992 by muller *)
(*      modified on Mon Jun 15 22:32:37 1992 by mhb *)

MODULE AnchorSplit;

IMPORT AnchorBtnVBT, Feedback, Filter, List, Multi, MultiClass, SwitchVBT, VBT;

REVEAL
  T = Public BRANDED OBJECT
             children: List.T := NIL;
           OVERRIDES
             init   := Init;
             pre    := SwitchVBT.Pre;
             post   := SwitchVBT.Post;
             cancel := SwitchVBT.Cancel;
           END;

REVEAL
  MC = MultiClass.T BRANDED OBJECT
    OVERRIDES
      replace := Replace;
      insert  := Insert;
      succ    := Succ;
    END;


PROCEDURE Init (v             : T;
                feedback      : Feedback.T;
                menuFrame     : Multi.T;
                n             : CARDINAL     := 0;
                anchorParent  : VBT.T        := NIL;
                hfudge, vfudge               := 0.0;
                multiclass    : MC           := NIL  ): T =
  BEGIN
    EVAL AnchorBtnVBT.T.init (v, feedback, menuFrame, n,
                              anchorParent, hfudge, vfudge);
    IF multiclass = NIL THEN multiclass := NEW (MC) END;
    MultiClass.Be (v, multiclass);
    <* ASSERT Multi.Child(feedback) = NIL *>
    <* ASSERT Multi.Child(menuFrame) = NIL *>
    RETURN v
  END Init;

PROCEDURE Insert (m: MC; pred, ch: VBT.T) =
  BEGIN
    WITH v = NARROW(m.vbt, T) DO
      MultiClass.BeChild(v, ch);
      IF pred = NIL THEN
        List.Push(v.children, ch)
      ELSE
        WITH p = Find(v.children, pred) DO
          p.tail := List.New(ch, p.tail);
        END;
      END;
      Update(v);
    END
  END Insert;

PROCEDURE Replace (m: MC; ch, new: VBT.T) =
  BEGIN
    <* ASSERT ch # NIL *>
    WITH v = NARROW(m.vbt, T) DO
      IF new = NIL THEN
        v.children := List.Delete(v.children, ch)
      ELSE
        WITH p = Find(v.children, ch) DO p.first := new END
      END;
      Update(v);
    END
  END Replace;
  
PROCEDURE Succ (m: MC; ch: VBT.T): VBT.T =
  BEGIN
    WITH v = NARROW(m.vbt, T) DO
      IF v.children = NIL THEN
        RETURN NIL
      ELSIF ch = NIL THEN
        RETURN List.First(v.children)
      ELSE
        WITH p = Find(v.children, ch) DO
          IF p.tail = NIL THEN
            RETURN NIL
          ELSE
            RETURN List.First(p.tail)
          END;
        END
      END
    END
  END Succ;

PROCEDURE Update (v: T) =
  BEGIN
    UpdateCh(v, Filter.Child(v), 0);
    UpdateCh(v, v.menu, 1)
  END Update;

PROCEDURE UpdateCh (v: T; frame: Multi.T; index: CARDINAL) =
  VAR new: VBT.T := NIL;
  BEGIN
    IF index < List.Length (v.children) THEN
      new := List.Nth (v.children, index)
    END;
    IF Multi.Child (frame) # new THEN
      EVAL Multi.ReplaceChild (frame, new);
    END
  END UpdateCh;

PROCEDURE Find (l: List.T; v: VBT.T): List.T =
  VAR rest := l;
  BEGIN
    WHILE rest # NIL DO
      IF rest.first = v THEN RETURN rest END;
      rest := rest.tail
    END;
    RETURN NIL
  END Find;
   
BEGIN
END AnchorSplit.



