(* Copyright (C) 1992, Digital Equipment Corporation                 *)
(* All rights reserved.                                              *)
(* See the file COPYRIGHT for a full description.                    *)
(*                                                                   *)
(* Last modified on Mon Aug 10  0:21:24 PDT 1992 by meehan           *)
(*      modified on Tue Jun 16 13:09:02 PDT 1992 by muller           *)
(*      modified on Mon Jun 15 10:20:42 1992 by mhb                  *)

(* A "BorderedFeedbackVBT" is a feedback that display a border as
   visual feedback to another "VBT".  In the ``on'' state, the
   border is drawn using the foreground color; in the ``off''
   state, the border is drawn using the background color.  In an
   ``excited'' state, the border is drawn with a gray pixmap; in
   the ``normal'' state, the border is drawn with a solid
   pixmap. *)

INTERFACE BorderedFeedbackVBT;

IMPORT BorderedVBT, FeedbackClass, PaintOp, VBT;

CONST
  PtsPerMM = 25.4 / 72.0;
  Default  = BorderedVBT.Default * PtsPerMM;

TYPE
  Points = REAL;
  T <: Public;
  Public = BorderedVBT.T OBJECT
           METHODS
             init (ch  : VBT.T;
                   size: Points  := Default;
                   op            := PaintOp.BgFg;
                   feedbackclass: FC           := NIL ): T
           END;

  FC <: FeedbackClass.T;

(* The type "FC" overrides the "normal" and "excited" methods
   of "FeedbackClass.T". *)

END BorderedFeedbackVBT.







