(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Aug  4 17:19:49 PDT 1992 by meehan     *)
(*      modified on Tue Jun 16 13:09:00 PDT 1992 by muller     *)
(*      modified on Fri Mar 27 02:30:36 1992 by steveg     *)
(*      modified on Sun Nov 17 15:48:43 PST 1991 by mhb        *)

MODULE ChoiceVBT;

IMPORT ButtonVBT, Feedback, Filter, Multi,
       MultiClass, Radio, VBT;

<* FATAL Radio.NotAMember, Multi.NotAChild *>

REVEAL
  T = Public BRANDED "ChoiceVBT.T" OBJECT
        group: Radio.T;
      OVERRIDES
        init     := Init;
        callback := DefaultCallback;
      END;

PROCEDURE Init (v         : T;
                switch    : ButtonVBT.T;
                group     : Radio.T;
                multiclass: MC            := NIL): T =
  BEGIN
    EVAL Filter.T.init (v, switch);
    v.group := group;
    switch.action := Action;
    Radio.Add (group, v);
    IF multiclass = NIL THEN multiclass := NEW (MC) END;
    MultiClass.Be (v, multiclass);
    IF Multi.Child (switch) # NIL THEN
      MultiClass.BeChild (v, Multi.Child (switch))
    END;
    RETURN v
  END Init;
  
PROCEDURE Action (s: ButtonVBT.T; READONLY cd: VBT.MouseRec) =
  BEGIN
    WITH v = NARROW(VBT.Parent(s), T) DO
      PutMember(v.group, v);
      v.callback(cd);
    END
  END Action;

PROCEDURE DefaultCallback (<* UNUSED *> self: T;
                           <* UNUSED *> READONLY cd: VBT.MouseRec) =
  BEGIN
  END DefaultCallback;

PROCEDURE Put (v: T) =
  BEGIN
    PutMember(v.group, v);
  END Put;

PROCEDURE Clear (v: T) =
  BEGIN
    PutMember(v.group, NIL);
  END Clear;

PROCEDURE PutMember (group: Radio.T; new: T) =
  PROCEDURE SetState (v: T; state: BOOLEAN) =
    BEGIN
      IF v # NIL THEN
        WITH s = Filter.Child(v), f = Filter.Child(s) DO
          Feedback.SetState(f, state)
        END
      END;
    END SetState;
  BEGIN
    SetState(NARROW(Radio.Get(group), T), FALSE);
    Radio.Put(group, new);
    SetState(new, TRUE);
  END PutMember;

PROCEDURE Get (v: T): T =
  BEGIN
    RETURN NARROW(Radio.Get(v.group), T);
  END Get;

PROCEDURE GetGroup (v: T): Radio.T =
  BEGIN
    RETURN v.group;
  END GetGroup;

(*
    PROCEDURE Replace (m: MultiClass.T; ch, new: VBT.T) =
      BEGIN
        WITH s = Filter.Child (m.vbt) DO Multi.Replace (s, ch, new) END
      END Replace;
    
    PROCEDURE Succ (m: MultiClass.T; ch: VBT.T): VBT.T =
      BEGIN
        WITH s = Filter.Child(m.vbt) DO RETURN Multi.Succ(s, ch) END
      END Succ;
    
    PROCEDURE Pred (m: MultiClass.T; ch: VBT.T): VBT.T =
      BEGIN
        WITH s = Filter.Child(m.vbt) DO RETURN Multi.Pred(s, ch) END
      END Pred;
*)

BEGIN
END ChoiceVBT.
