(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Mon Aug  3 14:47:51 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:08:51 PDT 1992 by muller *)
(*      modified on Fri Jun 12 00:41:14 1992 by mhb    *)
(* modified on Thu Sep 12 10:04:53 PDT 1991 by steveg *)

(* The "FlexShape" interface defines a {\em flexible size} specification
   that "FlexVBT" uses. 

   This interface defines some common types of
   flexible size ranges, such as adding inifinite stretch to a
   child's size, removing all stretch from a child, setting a
   size with neither stretch nor shrink, and so on.
 *)

INTERFACE FlexShape;

IMPORT Axis;

CONST
  Large    = 99999.0;
  Missing  = -Large;
  Infinity = Large;

TYPE
  Points = REAL;
  SizeRange = RECORD natural, shrink, stretch: Points END;
  Shape = ARRAY Axis.T OF SizeRange;

(* The following useful size-ranges are defined:
   "Default" uses child's size info. 
   "Fixed" uses child's preferred, removing all shrink and stretch.
   "Stretchy" uses child's preferred and shrink, giving infinite stretch. *)

CONST
  Default = 
    SizeRange {natural := Missing,
               shrink  := Missing, 
               stretch := Missing};

  Fixed = 
    SizeRange {natural := Missing, 
               shrink  := 0.0, 
               stretch := 0.0};

  Stretchy = 
    SizeRange {natural := Missing,
               shrink  := Missing, 
               stretch := Infinity};
               
PROCEDURE Rigid (natural: Points): SizeRange;
(* Return a "SizeRange" with the specified natural amount and
   with no stretch or shrink.  Equivalent to
|  SizeRange {natural, 0.0, 0.0}
*)

CONST (* for both dimensions: *)
  DefaultShape  = Shape{Default, Default};
  FixedShape    = Shape{Fixed, Fixed};
  StretchyShape = Shape{Stretchy, Stretchy};

END FlexShape.



