(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* Last modified on Mon Aug 10  0:26:20 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:08:41 PDT 1992 by muller *)
(* modified on Mon Jun 15 10:20:40 1992 by mhb *)
(* modified on Fri Mar 27 01:58:46 1992 by steveg *)

(* A "MarginFeedbackVBT" is a feedback (and also a multi-filter)
   that provides visual feedback to the left of another "VBT".
   The feedback-class "FC" displays the exact same pixmap for
   both normal and excited modes and for both states.  *)

INTERFACE MarginFeedbackVBT;

IMPORT FeedbackClass, HVSplit, MultiClass, Shadow, VBT;

TYPE
  T <: Public;
  Public = HVSplit.T OBJECT
           METHODS
             init (ch           : VBT.T;
                   marginVBT    : VBT.T;
                   multiclass   : MC      := NIL;
                   feedbackclass: FC      := NIL  ): T
           END;

  MC <: MultiClass.T;

(* The type "MC" overrides the "replace", "pred", and "succ"
     methods of "MultiClass.T". *)

  FC <: FeedbackClass.T;

(* The following procedures create some popular types of
   "MarginFeedbackVBT"s.  "NewCheck" displays a check mark or
   nothing; "NewBox" displays a box that is either empty or
   contains an ``x''; "NewBullet" displays a circle with or
   without a bullet in its center. *)

PROCEDURE NewCheck  (ch: VBT.T; shadow: Shadow.T := NIL): T;
PROCEDURE NewBox    (ch: VBT.T; shadow: Shadow.T := NIL): T;
PROCEDURE NewBullet (ch: VBT.T; shadow: Shadow.T := NIL): T;

END MarginFeedbackVBT.

