(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Wed Sep 30 10:26:14 PDT 1992 by mhb        *)
(*      modified on Mon Aug  3 11:34:51 PDT 1992 by meehan     *)
(*      modified on Tue Jun 16 13:08:31 PDT 1992 by muller     *)
<*PRAGMA LL*>

(* A "PixmapVBT.T" is a "VBT" that displays a pixmap, possibly colored. Its
   preferred and minimum sizes are the size of the pixmap, and its maximum
   size in each axis is very large. *)

INTERFACE PixmapVBT;

IMPORT VBT, PaintOp, Pixmap;

TYPE
  T <: Public;
  Public =
    VBT.Leaf OBJECT
    METHODS
      <* LL.sup <= VBT.mu *>
      init (pm: Pixmap.T; 
            op := PaintOp.BgFg;
            bg := PaintOp.Bg): T
    END;

(* The call "v.init(...)" initializes "v" as a "PixmapVBT"
   displaying pixmap "pm" using the paint-op "op", and returns
   "v".  Whenever "v" is made larger than the pixmap "pm", the
   pixmap is centered and the background is painting using the
   tint "bg". *)

PROCEDURE New (pm: Pixmap.T; op := PaintOp.BgFg; bg := PaintOp.Bg): T;
<* LL.sup <= VBT.mu *>
(* "New(...)" is equivalent to "NEW(T).init(...)". *)

PROCEDURE Put (v: T; pm: Pixmap.T);
<* LL.sup = VBT.mu *>
(* Change the pixmap displayed by "v" to "pm", and mark "v" for redisplay.
   If the size of the pixmap has changed, notify "v"'s parent that its shape
   has changed. *)

PROCEDURE SetColors (v: T; op: PaintOp.T; bg := PaintOp.Bg);
<* LL.sup = VBT.mu *>
(* Change the "op" and "bg" of "v" and mark "v" for redisplay. *)

END PixmapVBT.


