(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Fri Jul 31 23:13:51 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:08:17 PDT 1992 by muller *)
(*      modified on Sun Jun 14 02:07:10 1992 by mhb    *)
<* PRAGMA LL *>

(* A "ShadowedBarVBT.T" is a VBT that displays a horizontally or
   vertically oriented 3-D rectangle.

   If the shadow is "Raised" or "Ridged", the top (left) half
   of the "VBT" is drawn in the light color, and the bottom
   (right) half in the dark color.  If the shadow is "Lowered"
   or "Chiseled", the colors are reversed.  If the shadow is
   "Flat", then the entire "VBT" is drawn in the background color.
   *)

INTERFACE ShadowedBarVBT;

IMPORT Axis, Shadow, VBT;

TYPE
  T <: Public;
  Public = VBT.Leaf OBJECT
           METHODS
             <* LL.sup <= VBT.mu *>
             init (axis  : Axis.T;
                   shadow: Shadow.T := NIL;
                   style            := Shadow.Style.Flat): T;
           END;

(* The call "v.init(...)" initializes "v" as a "ShadowedBarVBT"
   with the "axis" orientation and with the given "shadow" and
   "style".  If "shadow=NIL", it defaults to "Shadow.None".  If
   the "shadow.size" along the "axis" dimension results in an odd
   number of pixels, the extra pixel goes to the top (left) half.
   The shape of "v" is "ABS(shadow.size)" along the primary axis,
   and unconstrained in the other dimension. *)

PROCEDURE New (axis  : Axis.T;
               shadow: Shadow.T := NIL;
               style            := Shadow.Style.Flat): T;
<* LL.sup <= VBT.mu *>
(* "New(...)" is equivalent to "NEW(T).init(...)". *)

PROCEDURE Set (v: T; shadow: Shadow.T);
<* LL.sup = VBT.mu *>
(* Change the size and colors of "v"'s shadow and mark "v" for
   redisplay.  If the size has in fact changed, notify "v"'s
   parent that "v"'s shape has changed. *)

PROCEDURE SetStyle (v: T; style: Shadow.Style);
<* LL.sup = VBT.mu *>
(* Change the style of "v"'s shadow and mark "v" for
   redisplay. *)

END ShadowedBarVBT.

