(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Fri Jul 31 17:55:24 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:08:16 PDT 1992 by muller *)
(*      modified on Mon Jun 15 18:43:10 1992 by mhb *)
(* modified on Thu Sep 12 10:59:15 PDT 1991 by steveg *)

MODULE ShadowedFeedbackVBT;

IMPORT Feedback, FeedbackClass, 
         Filter, HighlightVBT, Pixmap, Point, Rect, Shadow,
         ShadowedVBT, VBT;

REVEAL
  T = Public BRANDED OBJECT
        shadow       : Shadow.T;
        highlighter  : HighlightVBT.T;
        normalStyles : ARRAY BOOLEAN OF Shadow.Style;
        excitedStyles: ARRAY BOOLEAN OF Shadow.Style
      OVERRIDES
        init := Init
      END;

REVEAL
  FC = FeedbackClass.T BRANDED OBJECT
       OVERRIDES
         normal   := Normal;
         excited  := Excited;
       END;

PROCEDURE Init (v      : T;
                ch     : VBT.T;
                shadow : Shadow.T := NIL;
                onStyle           := Shadow.Style.Raised;
                onExcitedStyle      := Shadow.Style.Lowered;
                offStyle            := Shadow.Style.Raised;
                offExcitedStyle     := Shadow.Style.Lowered;
                feedbackclass  : FC := NIL                   ):
  T =
  BEGIN
    IF shadow = NIL THEN shadow := Shadow.None END;
    EVAL ShadowedVBT.T.init (v, ch, shadow);
    v.shadow := shadow;
    v.normalStyles [TRUE] := onStyle;
    v.normalStyles [FALSE] := offStyle;
    v.excitedStyles [TRUE] := onExcitedStyle;
    v.excitedStyles [FALSE] := offExcitedStyle;
    IF feedbackclass = NIL THEN feedbackclass := NEW (FC) END;
    FeedbackClass.Be (v, feedbackclass);
    Feedback.Normal (v);
    RETURN v
  END Init;

PROCEDURE Normal (fc: FC) =
  BEGIN
    WITH v = NARROW (fc.vbt, T) DO
      ShadowedVBT.SetStyle (v, v.normalStyles [Feedback.GetState (v)]);
      IF NOT Shadow.Supported (v.shadow, v) THEN Highlight (v, FALSE) END;
    END
  END Normal;

PROCEDURE Excited (fc: FC) =
  BEGIN
    WITH v = NARROW(fc.vbt, T) DO
      IF Shadow.Supported(v.shadow, v) THEN
        ShadowedVBT.SetStyle(v, v.excitedStyles[Feedback.GetState(v)]);
      ELSE
        Highlight(v, TRUE)
      END
    END
  END Excited;

PROCEDURE Highlight (v: T; excite: BOOLEAN) =
  VAR
    ch: VBT.T;
    hl: HighlightVBT.T;
    r : Rect.T;
    sz: CARDINAL;
  BEGIN
    ch := Filter.Child(v);
    IF excite THEN
      hl := HighlightVBT.Find(v);
      v.highlighter := hl;
      r := VBT.Domain(ch);
      sz := 99999
    ELSE
      hl := v.highlighter;
      v.highlighter := NIL;
      r := Rect.Empty;
      sz := 0
    END;
    HighlightVBT.SetTexture(hl, Pixmap.Solid, Point.Origin, v.shadow.swap);
    HighlightVBT.SetRect(hl, r, sz)
  END Highlight;

PROCEDURE NewMenu (ch: VBT.T; shadow: Shadow.T := NIL): T =
  BEGIN
    RETURN
      NEW (T).init (ch, shadow, Shadow.Style.Flat, Shadow.Style.Lowered,
                    Shadow.Style.Flat, Shadow.Style.Lowered);
  END NewMenu;

BEGIN
END ShadowedFeedbackVBT.
