(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Fri Aug  7 23:04:01 PDT 1992 by meehan     *)
(*      modified on Tue Jun 16 13:08:08 PDT 1992 by muller     *)
(*      modified on Fri Jun 12 19:08:57 1992 by mhb        *)
(*      modified on Fri Jul 26 15:36:28 PDT 1991 by steveg     *)

MODULE TrillSwitchVBT;

IMPORT AutoRepeat, ButtonVBT, Feedback, Filter, Multi,
       MultiClass, VBT;

REVEAL
  T = Public BRANDED OBJECT
        firstDown: VBT.MouseRec;
        repeater : Repeater
      OVERRIDES
        init     := Init;
        callback := Callback;
        pre      := Pre;
        post     := Post;
        cancel   := Cancel;
        mouse    := Mouse;
      END;

TYPE
  Repeater =
    AutoRepeat.T OBJECT v: T OVERRIDES repeat := Repeat END;

PROCEDURE Init (v: T; f: Feedback.T; multiclass: MC := NIL): T =
  BEGIN
    EVAL ButtonVBT.T.init (v, f, Action);
    IF multiclass = NIL THEN multiclass := NEW (MC) END;
    MultiClass.Be (v, multiclass);
    MultiClass.BeChild (v, Multi.Child (f));
    v.repeater := NEW (Repeater, v := v).init ();
    RETURN v
  END Init;

PROCEDURE Action(
    <* UNUSED *> selfAsButtonVBT: ButtonVBT.T; 
    <* UNUSED *> READONLY cd: VBT.MouseRec) =
  BEGIN
  END Action;

PROCEDURE Callback ( <* UNUSED *> v: T;  
                     <* UNUSED *> READONLY cd: VBT.MouseRec) =
  BEGIN
  END Callback;

PROCEDURE Repeat (r: Repeater) =
  BEGIN
    WITH v = r.v DO
      v.firstDown.time := 0;
      v.callback(v.firstDown)
    END
  END Repeat;

PROCEDURE Pre (v: T) =
  BEGIN
    Feedback.Excited(Filter.Child(v));
    v.callback(v.firstDown);
    v.repeater.start ()
  END Pre;

PROCEDURE Post (v: T) =
  BEGIN
    v.repeater.stop ();
    Feedback.Normal (Filter.Child (v));
  END Post;

PROCEDURE Cancel (v: T) =
  BEGIN
    v.repeater.stop ();
    Feedback.Normal(Filter.Child(v));
  END Cancel;

PROCEDURE Mouse (v: T; READONLY cd: VBT.MouseRec) =
  BEGIN
    IF cd.clickType = VBT.ClickType.FirstDown THEN v.firstDown := cd END;
    ButtonVBT.T.mouse(v, cd)
  END Mouse;

BEGIN
END TrillSwitchVBT.
