(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Wed Aug  5 21:46:41 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:07:57 PDT 1992 by muller *)
(*      modified on Mon Jun 15 19:01:24 1992 by mhb *)
(* modified on Fri Mar 27 02:12:27 1992 by steveg*)
<*PRAGMA LL*>

(* A "ZMoveVBT" is a switch that has the side-effect of
   repositioning its nearest ancestor that's a non-background
   child of a "ZSplit".  In other words, a "ZMoveVBT" should be a
   descendant of a non-background child of some "ZSplit"; call
   the child "ch".  The "ZMoveVBT" has the side-effect of moving
   "ch".

   If the initial mouse click is unshifted, child "ch" is lifted
   to the top of its sibling; otherwise, child "ch" keeps its
   current top-to-bottom ordering among its siblings.  As the
   mouse is moved, the cursor is changed to give appropriate
   feedback, and an outline of child "ch" is moved to show where
   "ch" will be repositioned on an uncancelled upclick.  On an
   uncancelled upclick, the outline is removed and the child is
   moved if it isn't over an active target.  The outline is also
   removed on a chord-cancel.

   As the outline is being dragged, whenever the mouse is over a
   ``target'' (as in "SourceVBT.Target") and the "hit" method
   returns "TRUE", the outline is removed. *)

INTERFACE ZMoveVBT;

IMPORT Rect, SourceVBT;

TYPE T <: SourceVBT.T;

PROCEDURE MoveAndHighlight (v: T; READONLY rect: Rect.T);
(* Move the outline of "v"'s rect to "rect".  Highlighting is
   done in the "HighlightVBT" returned by
   "SourceVBT.GetHighlighter(v)".  This procedure is particularly
   useful to the "during" method of subclasses, such as
   "ZGrowVBT". *)

END ZMoveVBT.








