(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Jun 16 13:16:23 PDT 1992 by muller     *)
(*      modified on Fri Nov 22 20:13:46 PST 1991 by meehan     *)
(*      modified on Wed May  3 11:10:09 PDT 1989 by mbrown     *)
(*      modified on Tue Oct 11 19:06:48 1988 by chan           *)

INTERFACE MTextRd;

IMPORT Range, Rd, MText;

TYPE
  T <: Rd.T;
  
PROCEDURE New (m         : MText.T;
               start     : CARDINAL  := 0;
               rangeStart: CARDINAL  := 0;
               rangeEnd  : CARDINAL  := LAST(CARDINAL);
               reverse   : BOOLEAN   := FALSE;
               alertable : BOOLEAN   := FALSE           ): T
  RAISES {Range.Error};

(* Creates a reader to read the characters between indices rangeStart
     and rangeEnd-1 in m.  rangeEnd := MIN (rangeEnd, MText.Length (m)).
     rangeStart <= start <= rangeEnd.  The reader is positioned at start.
|
     In a forward reader, characters are delivered from start to
     rangeEnd-1.  Reading past the last character raises Rd.EndOfFile.
     Rd.GetIndex returns the index relative to rangeStart.  Hence if
     rd is created with reverse = FALSE, then just after rd is created
|                Rd.GetIndex(rd) = start - rangeStart
|
     In a reverse reader, characters are delivered from start-1 to
     rangeStart.  Rd.GetIndex returns the index relative to rangeEnd.
     Hence if rd is created with reverse = TRUE, then just after rd
     is created
|                Rd.GetIndex(rd) = rangeEnd - start
|
     This way, the value returned by GetIndex increases by 1 with each
     GetChar, regardless of whether the reading is normal or reversed.
|
     The coordinate system used by Rd.Seek is consistent with
     Rd.GetIndex.  However, you cannot seek outside [rangeStart ..
     rangeEnd).  Rd.Seek(rd, i) = Rd.Seek(MIN(MAX(i, 0), Rd.Length(rd)).
|
     Rd.GetChar may or may not raise Rd.Failure(IOError) if m is
     modified after the reader was created.  (It might not raise it,
     because Rd may be reading from its local buffer.)
|
     Synchronization: it is not possible to have several readers reading
     the mtext concurrently.  The reason is that a read to a file node
     causes the mtext data structure to change.  If you don't use file
     nodes, then it's safe.
*)

END MTextRd.
