(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified On Tue Jun 16 13:12:47 PDT 1992 by muller *)
(*      modified On Mon Oct 14 22:55:02 PDT 1991 by meehan *)
(* Modified On Tue Sep 15 01:28:26 1987 by jdd *)

INTERFACE VT;

IMPORT MText, Rd, Thread, VTDef;

TYPE
  T = VTDef.T;
  ErrorCode = VTDef.ErrorCode;
  I = VTDef.I;

PROCEDURE New (mtext: MText.T): T RAISES {VTDef.Error};

PROCEDURE Replace (vt: T; begin, end: CARDINAL; text: TEXT)
  RAISES {Rd.EndOfFile, Rd.Failure, Thread.Alerted};


PROCEDURE ReplaceSub (             vt        : T;
                                   begin, end: CARDINAL;
                      VAR (* IN *) str       : ARRAY OF CHAR;
                                   start     : I               := 0;
                                   length    : I               := LAST (I))
  RAISES {Rd.EndOfFile, Rd.Failure, Thread.Alerted};


PROCEDURE ReplaceFile (vt        : T;
                       begin, end: CARDINAL;
                       file      : Rd.T;
                       start     : I          := 0;
                       numChars  : I          := LAST (I))
  RAISES {Rd.EndOfFile, Rd.Failure, Thread.Alerted};


PROCEDURE Close (t: T) RAISES {};

PROCEDURE Invalidate (vt: T; b, e: I; l: CARDINAL)
  RAISES {Rd.EndOfFile, Rd.Failure, Thread.Alerted};

END VT.
