(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified On Tue Jun 16 13:12:43 PDT 1992 by muller *)
(*      modified On Mon Oct 14 21:48:47 PDT 1991 by meehan *)
(*      Modified On Tue Dec 18 09:15:58 1990 by jdd *)

INTERFACE VTInterval;

IMPORT VTDef;

TYPE
  T = VTDef.T;
  ColorScheme = VTDef.ColorScheme;
  I = VTDef.I;
  Index = VTDef.Index;
  Interval = VTDef.Interval;
  IntervalOptions = VTDef.IntervalOptions;
  IntervalStyle = VTDef.IntervalStyle;
  OnOffState = VTDef.OnOffState;
  Tint = VTDef.Tint;
  View = VTDef.View;


PROCEDURE New
  (vt: T; iL, iR: Index; READONLY options: IntervalOptions): Interval
   RAISES {};

PROCEDURE MakeOptions
  (style: IntervalStyle; whiteBlack, whiteStroke: ColorScheme; leading: Tint)
   : IntervalOptions RAISES {};

PROCEDURE Switch (interval: Interval; state: OnOffState) RAISES {};

PROCEDURE Move (interval: Interval; iL, iR: Index) RAISES {};

PROCEDURE ChangeOptions
  (interval: Interval; READONLY options: IntervalOptions) RAISES {};

PROCEDURE Close (interval: Interval) RAISES {};

PROCEDURE Fix (vt: T) RAISES {};

PROCEDURE CurrentOptions
  (view: View; at: I; VAR (*OUT*) from, to: I): IntervalOptions RAISES {};

END VTInterval.
