(* Copyright 1992 Digital Equipment Corporation.           *)
(* Distributed only by permission.                         *)
(* Last modified on Thu Aug 13 15:44:56 PDT 1992 by johnh  *)
(*      modified on Tue May 12 08:37:40 1992 by mhb        *)

INTERFACE ViewClass;

IMPORT Thread, View;

TYPE
  T = View.Public BRANDED OBJECT
        name      : TEXT               := NIL;
        evtHandler: Thread.T;
        evtCond   : Thread.Condition;
        evtArg    : REFANY;
        evtHandled: BOOLEAN;
      END;

(* The "name" field is set by Zeus immediately after a "View.T" has been
   instantiated.  Thereafter, the field is read-only. *)
(* The "evtHandler" field is a worker thread tickled by Zeus to process
   each output event when it occurs.  evtCond and evtArg are used in the
   coroutines for output event procesing.*)
(* The "evtHandled" field is set to FALSE by the default output event
   methods.  User-provided event handlers will not see this field, and
   hence will not set it.  The event dispatcher uses this field to decide
   whether an event was handled by any view. *)

REVEAL View.T <: T;
END ViewClass.

