(* Copyright 1992 Digital Equipment Corporation. *)
(* Distributed only by permission. *)
(* Last modified on Sat Oct 17 23:51:22 PDT 1992 by mhb *)
(*      modified on Thu Aug 13 16:29:03 PDT 1992 by johnh *)

(*********************************************************************
|*  NOTE: This file is generated automatically from the event 
|*        definition file #(_ALGNAME_).evt.
 *********************************************************************)

MODULE #(_ALGNAME_)TranscriptView;

#(_IMPORTS_)
IMPORT #(_ALGNAME_)ViewClass;
IMPORT Fmt, FormsVBT, List, ReactivityVBT;
IMPORT TextEditVBT, TextPort, VBT, View, Wr, ZeusClass, ZeusPanel;

<* PRAGMA LL *>

<* FATAL FormsVBT.Error *>

REVEAL
  T = Public BRANDED OBJECT
    fv: FormsVBT.T;
    te: TextEditVBT.T;
  OVERRIDES
    init       := TViewInit;
    install    := TViewInstall;
    delete     := TViewDelete;
    snapshot   := TViewSnapshot;
    restore    := TViewRestore;
    config     := TViewConfig;
    reactivity := TViewReactivity;
    startrun   := TViewStartrun;
    endrun     := TViewEndrun;
#{_OUTPUT
    oe#(_EVENT_) := #(_EVENT_);
#}
#{_UPDATE
    ue#(_EVENT_) := #(_EVENT_);
#}
  END;

PROCEDURE TViewInit (view: T): T =
  <* LL = VBT.mu *>
  BEGIN
    view.fv := ZeusPanel.NewForm("#(_ALGNAME_)TranscriptView.fv");
    view.te := FormsVBT.GetVBT(view.fv, "transcript");
    FormsVBT.AttachProc(view.fv, "clear", Clear, view);
    TViewZTrace (view, "init");
    RETURN #(_ALGNAME_)ViewClass.T.init (view, view.fv);
  END TViewInit;

PROCEDURE Clear (<* UNUSED *> fv  : FormsVBT.T;
                 <* UNUSED *> name: TEXT;
                              cl  : REFANY;
                 <* UNUSED *> time: VBT.TimeStamp) =
  BEGIN
    TextPort.SetText(NARROW(cl, T).te.port, "")
  END Clear;

PROCEDURE TViewInstall (view: T) =
  <* LL = VBT.mu *>
  BEGIN
    TViewZTrace (view, "install");
    #(_ALGNAME_)ViewClass.T.install (view);
  END TViewInstall;

PROCEDURE TViewDelete (view: T) =
  <* LL = VBT.mu *>
  BEGIN 
    TViewZTrace (view, "delete");
    #(_ALGNAME_)ViewClass.T.delete (view);
   END TViewDelete;

PROCEDURE TViewSnapshot (view: T; wr: Wr.T) RAISES {ZeusClass.Error} =
  <* LL = VBT.mu *>
  BEGIN 
    TViewZTrace (view, "snapshot");
    #(_ALGNAME_)ViewClass.T.snapshot (view, wr);
   END TViewSnapshot;

PROCEDURE TViewRestore (view: T; l: List.T) RAISES {ZeusClass.Error} =
  <* LL = VBT.mu *>
  BEGIN 
    TViewZTrace (view, "restore");
    #(_ALGNAME_)ViewClass.T.restore (view, l);
   END TViewRestore;

PROCEDURE TViewConfig (
    view: T; 
    state: ZeusClass.StateChange; 
    o: ZeusClass.T) =
  <* LL = VBT.mu *>
  BEGIN 
    TViewZTrace (view, "config");
    #(_ALGNAME_)ViewClass.T.config (view, state, o);
   END TViewConfig;

PROCEDURE TViewReactivity (view: T; <*UNUSED*> on: BOOLEAN) =
  <* LL = VBT.mu *>
  BEGIN
    TViewZTrace(view, "reactivity");
    ReactivityVBT.Set(view, ReactivityVBT.State.Active);
  END TViewReactivity;

PROCEDURE TViewStartrun (view: T) =
  <* LL = {} *>
  BEGIN 
    TViewZTrace (view, "startrun");
    #(_ALGNAME_)ViewClass.T.startrun (view);
   END TViewStartrun;

PROCEDURE TViewEndrun (view: T) =
  <* LL = {} *>
  BEGIN 
    TViewZTrace (view, "endrun");
    #(_ALGNAME_)ViewClass.T.endrun (view);
  END TViewEndrun;


(* event handling methods: *)

#{_OUTPUT
PROCEDURE #(_EVENT_) (view: T; #(_ARGSTR_)) =
  <* LL = {} *>
  BEGIN 
    LOCK VBT.mu DO
      TViewTrace (view, "#(_EVENT_) " 
#{
      & #(_ARGFMT_)(#(_ARGNAME_))
#|
      & " "
#}
      )
    END;
  END #(_EVENT_);

#}


#{_UPDATE
PROCEDURE #(_EVENT_) (view: T; #(_ARGSTR_)) =
  <* LL = VBT.mu *>
  BEGIN 
    TViewTrace (view, "#(_EVENT_) " 
#{
    & #(_ARGFMT_)(#(_ARGNAME_))
#|
    & " "
#}
    )
  END #(_EVENT_);

#}


PROCEDURE TViewZTrace (view: T; t: TEXT) =
  BEGIN
    IF FormsVBT.IsSelected (view.fv, "zeus") OR 
       FormsVBT.IsSelected (view.fv, "both") THEN 
      TextPort.PutText (view.te.port, "**zeus:  " & t & "\n");
      TextPort.Normalize (view.te.port, LAST(INTEGER)) 
    END
  END TViewZTrace;

PROCEDURE TViewTrace (view: T; t: TEXT) =
  BEGIN
    IF FormsVBT.IsSelected (view.fv, "alg") OR 
       FormsVBT.IsSelected (view.fv, "both") THEN 
      TextPort.PutText (view.te.port, "--event: " & t & "\n");
      TextPort.Normalize (view.te.port, LAST(INTEGER))
   END
  END TViewTrace;


PROCEDURE TViewNew (): View.T =
  BEGIN
    RETURN NEW(T).init()
  END TViewNew;


BEGIN
  ZeusPanel.RegisterView 
      (TViewNew, "#(_ALGNAME_) Transcript View", "#(_ALGNAME_)"); 
END #(_ALGNAME_)TranscriptView.
