/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	ctype.h,v $
 * Revision 4.2.2.2  92/03/27  15:21:16  Craig_Horman
 * 	Merge with AG
 * 	[92/03/27  13:50:41  Craig_Horman]
 * 
 * 	Merge with BL5
 * 	[92/03/10  11:36:01  Craig_Horman]
 * 
 * 	Added C++ Support
 * 	[92/02/26  15:12:00  Craig_Horman]
 * 
 * Revision 4.2  91/09/20  05:14:23  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: ctype.h,v $ $Revision: 4.2.2.2 $ (DEC) $Date: 92/03/27 15:21:16 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */

/*
 * COMPONENT_NAME: (LIBCGEN) Standard C Library General Functions
 *
 * FUNCTIONS: 
 *
 * ORIGINS: 27
 *
 * (C) COPYRIGHT International Business Machines Corp. 1985, 1989
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
#ifndef _CTYPE_H_
#define _CTYPE_H_

#include <standards.h>

/*
 *
 *      The ANSI and XOPEN standards require that certain values be in ctype.h.
 *      They also require that if _ANSI_C_SOURCE or _XOPEN_SOURCE is defined
 *      then ONLY those standard specific values are present. This header
 *      includes all the ANSI and XOPEN required entries.
 *
 */

#ifdef   _ANSI_C_SOURCE

#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C" {
#endif
extern int isalpha(int);
extern int isalnum(int);
extern int iscntrl(int);
extern int isdigit(int);
extern int isgraph(int);
extern int isprint(int);
extern int ispunct(int);
extern int isspace(int);
extern int isxdigit(int);
extern int isupper(int);
extern int islower(int);
extern int tolower(int);
extern int toupper(int);
#if defined(__cplusplus)
}
#endif /* __cplusplus */
#else  /* __STDC__ */
extern int isalpha();
extern int isalnum();
extern int isdigit();
extern int iscntrl();
extern int ispunct();
extern int isprint();
extern int isspace();
extern int isgraph();
extern int isxdigit();
extern int islower();
extern int isupper();
extern int toupper();
extern int tolower();
#endif /* __STDC__ */

#endif /*_ANSI_C_SOURCE */

#ifdef _XOPEN_SOURCE

#include <NLctype.h>

/*
 *  NOTE!!!  All of these character classifications are duplicated in
 *	     usr/bin/ctab.c and they must always match EXACTLY.  Change
 *	     them here and the identical change(s) must be made to
 *	     ctab.c!
 */
#define	_U	   01
#define	_L	   02
#define	_N	   04
#define	_S	  010
#define	_P	  020
#define	_C	  040
#define	_B	 0100
#define	_X	 0200
#define _A       0400
#define _G      01000

#define _ctype  (_locp->lc_chrtbl)->lc_ctype

#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C" {
#endif
extern int isascii(int);
extern int toascii(int);
#if defined(__cplusplus)
}
#endif   /* __cplusplus */
#else    /* __STDC__ */
extern int isascii();
extern int toascii();
#endif   /* _STDC__ */

/* To ensure correct funtionality outside ASCII, the following macros
 * now  use the same code as the corresponding functions.
 */
#define	_toupper(c)	( ((_locp->lc_chrtbl)->lc_caseconv+1)[c] )
#define	_tolower(c)	( ((_locp->lc_chrtbl)->lc_caseconv+1)[c] )

#endif /* _XOPEN_SOURCE */
 
#endif /* _CTYPE_H_ */
