/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	cma_ux.h,v $
 * Revision 4.2  91/09/20  04:59:07  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*
 *	@(#)$RCSfile: cma_ux.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/20 04:59:07 $
 */
/*
 *  Copyright (c) 1989, 1991 by
 *  Digital Equipment Corporation, Maynard Massachusetts.
 *  All rights reserved.
 *
 *  This software is furnished under a license and may be used and  copied
 *  only  in  accordance  with  the  terms  of  such  license and with the
 *  inclusion of the above copyright notice.  This software or  any  other
 *  copies  thereof may not be provided or otherwise made available to any
 *  other person.  No title to and ownership of  the  software  is  hereby
 *  transferred.
 *
 *  The information in this software is subject to change  without  notice
 *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment
 *  Corporation.
 *
 *  DIGITAL assumes no responsibility for the use or  reliability  of  its
 *  software on equipment which is not supplied by DIGITAL.
 */

/*
 *  FACILITY:
 *
 *	CMA services
 *
 *  ABSTRACT:
 *
 *	Header file for unix system call wrapper routines
 *
 *  AUTHORS:
 *
 *	Hans Oser
 *
 *  CREATION DATE:
 *
 *	19 September 1989
 *
 *  MODIFICATION HISTORY:
 *
 *	001	Webb Scales	6 December 1989
 *		Made inclusion conditional, added macros for memory allocation
 *		routines, added CMA routine prototypes.
 *	002	Dave Butenhof	18 December 1989
 *		Change ifndef name for module to correspond to file name.
 *	003	Dave Butenhof	13 February 1990
 *		Add a macro for errno reference (this version still uses the
 *		global per-process errno, but the macro access mechanism
 *		should help locate code which might be incompatible with the
 *		final multiprocessor-compatible solution, which will require
 *		such a macro).
 *	004	Webb Scales	22 March 1990
 *		Add definintions for 'sigwait' function.
 *	005	Webb Scales	27 March 1990
 *		Deleted cma_shutdown, added cma_socketpair.
 *		Split the C RTL wrappers, et al, off into cma_crtlx.h
 *	006	Webb Scales	24 July 1990
 *		Added 'creat', 'dup', and 'dup2'.
 *	007	Webb Scales	16 August 1990
 *		Added Apollo changes for new platforms
 *	008	Webb Scales	23 October 1990
 *		Added "import fd" routine.
 *	009	Paul Curtin	11 December 1990
 *		Added msghdr data structure.
 *	010	Webb Scales	11 December 1990
 *		Added wrapper for fcntl().
 *	011	Paul Curtin	31 January 1991
 *		Added _CMA_NOWRAPPERS_ conditional statement
 *	012	Dave Butenhof	5 February 1991
 *		To avoid breaking client code (now that this is pulled in
 *		transparently by cma.h, pthread.h, pthread_exc.h), drop all
 *		the header file includes; which means also dropping the
 *		prototypes (oh well).
 *	013	Dave Butenhof	12 February 1991
 *		Add fork wrapper
 *	014	Paul Curtin	24 April 1991
 *		Removed all wrapper routine prototypes.  Routine
 *		prototypes should now be picked up from the original
 *		headers and #defined to be protos for our routines.
 *		***NOTE: this makes the assumption that the argument
 *		types defined in our wrappers match all protos on all systems.
 *	015	Webb Scales	2 May 1991
 *		Moved the cma_import_fd prototype here, as this is the best
 *		of several poor choices.
 *	016	Dave Butenhof	23 May 1991
 *		Add conditionals for _CMA_UNIPROCESSOR_ so kernel-thread
 *		versions of DECthreads can still use some wrappers (e.g.,
 *		cma_fork()).
 *	017	Webb Scales	30 May 1991
 *		Created an un-import_fd function, and put the prototype here
 *		so it is with the import_fd function.
 *	018	Paul Curtin	06 June 1991
 *		Added Al Simon's atfork work. 
 */


#ifndef CMA_UX
#define CMA_UX

/*
 *  INCLUDE FILES
 */

/*
 * CONSTANTS AND MACROS
 */

#if !defined(_CMA_NOWRAPPERS_) && _CMA_UNIPROCESSOR_
/*
 * U*ix I/O System Call Wrappers
 */
# define accept	    cma_accept
# define close	    cma_close
# define connect    cma_connect
# define creat	    cma_creat
# define dup	    cma_dup
# define dup2	    cma_dup2
# define fcntl	    cma_fcntl
# define open	    cma_open
# define pipe	    cma_pipe
# define recv	    cma_recv
# define recvmsg    cma_recvmsg
# define recvfrom   cma_recvfrom
# define read	    cma_read
# define readv	    cma_readv
# define select	    cma_select
# define send	    cma_send
# define sendmsg    cma_sendmsg
# define sendto	    cma_sendto
# define socket	    cma_socket
# define socketpair cma_socketpair
# define write	    cma_write
# define writev	    cma_writev
#endif

/*
 * U*ix process control wrappers
 */
#if !defined(_CMA_NOWRAPPERS_)
# define fork	    cma_fork
# define atfork	    cma_atfork
# if !_CMA_UNIPROCESSOR_
#  define cma_import_fd(fd)
# endif
#endif


/*
 * TYPEDEFS
 */


typedef void (*cma_t_fork_rtn) _CMA_PROTOTYPE_ ((
        cma_t_address   arg));

/*
 *  GLOBAL DATA
 */

/*
 * INTERFACES
 */

extern void
cma_atfork _CMA_PROTOTYPE_ ((
        cma_t_address user_state,
        cma_t_fork_rtn pre_fork,
        cma_t_fork_rtn parent_fork,
        cma_t_fork_rtn child_fork));

                                    
#if _CMA_UNIPROCESSOR_
extern void
cma_import_fd _CMA_PROTOTYPE_ ((
	int		fd));

extern void
cma_unimport_fd _CMA_PROTOTYPE_ ((
	int		fd));
#endif

#endif
/*  DEC/CMS REPLACEMENT HISTORY, Element CMA_UX.H */
/*  *13   10-JUN-1991 19:58:02 SCALES "Convert to stream format for ULTRIX build" */
/*  *12   10-JUN-1991 19:22:21 BUTENHOF "Fix the sccs headers" */
/*  *11   10-JUN-1991 18:25:10 SCALES "Add sccs headers for Ultrix" */
/*  *10    6-JUN-1991 11:23:15 CURTIN "Added Al Simon's atfork work" */
/*  *9    31-MAY-1991 18:43:33 SCALES "Create an un-import_fd function" */
/*  *8    29-MAY-1991 17:02:21 BUTENHOF "Change wrapper macros for MP" */
/*  *7     2-MAY-1991 22:29:53 SCALES "Move cma_import_fd prototype here" */
/*  *6    24-APR-1991 12:11:03 CURTIN "removed all wrapper routine prototypes" */
/*  *5    13-FEB-1991 00:01:19 BUTENHOF "Implement fork(2) wrapper" */
/*  *4     6-FEB-1991 01:33:28 BUTENHOF "Drop prototypes to avoid pulling in signal.h, socket.h, etc." */
/*  *3    31-JAN-1991 16:46:30 CURTIN "added _CMA_NOWRAPPERS_ conditional statement" */
/*  *2    18-DEC-1990 01:03:31 SCALES "Add fctnl() wrapper" */
/*  *1    12-DEC-1990 21:55:41 BUTENHOF "UNIX service emulation header" */
/*  DEC/CMS REPLACEMENT HISTORY, Element CMA_UX.H */
