/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	presto_data.c,v $
 * Revision 1.1.3.12  92/06/29  15:15:01  Chet_Juszczak
 * 	fixes for dev_t changes
 * 	[92/06/29  15:03:49  Chet_Juszczak]
 * 
 * 	merge to AG
 * 	[92/04/21  09:56:33  Chet_Juszczak]
 * 
 * 	remove crud
 * 
 * 	Merged bug fixes from Chet.
 * 	[92/03/23  11:41:34  Paul_Shaughnessy]
 * 
 * Revision 1.1.3.11  92/05/07  13:22:39  Thomas_Tierney
 * 	Merge with AG.
 * 	[92/05/07  12:42:34  Thomas_Tierney]
 * 
 * 	Check in for next ag.latest merge.
 * 	[92/04/30  10:11:44  Thomas_Tierney]
 * 
 * 	Check-in for remerge
 * 	[92/04/30  09:36:05  Thomas_Tierney]
 * 
 * 	Merge
 * 	[92/04/23  10:34:53  Thomas_Tierney]
 * 
 * 	Merged Maria Vella's CAM dev_t expansion work.
 * 	[92/04/21  16:16:51  Thomas_Tierney]
 * 
 * 	Added KZQSA support.
 * 	[92/03/06  14:46:46  William_Dallas]
 * 
 * 	Merged changes from shared SB
 * 	[92/02/26  11:30:59  cam_proj_Janet_Schank]
 * 
 * 	Removed references to scsi.h. Added use of cdisk_close().
 * 	[92/02/19  08:34:06  Janet_Schank]
 * 
 * Revision 1.1.3.10  92/04/21  10:19:27  Chet_Juszczak
 * 	"fs perf fixes"
 * 
 * Revision 1.1.3.9  92/03/24  15:59:25  Paul_Shaughnessy
 * 	Merge in bug fix from Chet
 * 	[92/03/24  09:50:59  Paul_Shaughnessy]
 * 
 * 	Merge to AG
 * 	[92/03/23  13:00:18  Paul_Shaughnessy]
 * 
 * 	Merged bug fixes from Chet.
 * 	[92/03/23  11:41:34  Paul_Shaughnessy]
 * 
 * Revision 1.1.3.8  92/03/11  09:47:18  cam_proj_Janet_Schank
 * 	"bsubmitted from shared SB"
 * 
 * Revision 1.1.3.7  92/03/02  10:35:46  Janet_Schank
 * 	Fix merge error.
 * 	[92/03/02  10:35:08  Janet_Schank]
 * 
 * Revision 1.1.3.6  92/03/01  17:57:34  cam_proj_Janet_Schank
 * 	Removed references to NSCSI.
 * 	[92/03/01  17:56:49  cam_proj_Janet_Schank]
 * 
 * Revision 1.1.3.5  92/02/27  15:54:35  cam_proj_Janet_Schank
 * 	"bsubmitted from shared SB"
 * 
 * Revision 1.1.3.4  92/02/24  11:43:28  Peter_Keilty
 * 	bmerge against ag.latest
 * 	[92/02/23  13:32:56  Peter_Keilty]
 * 
 * 	Initial checkin of DSA IO subsystem and
 * 	related system files
 * 	[92/02/12  18:35:40  Peter_Keilty]
 * 
 * Revision 1.1.3.3  91/12/20  13:08:35  William_Burns
 * 	revision 3.6.9.2
 * 	date: 91/11/19 13:45:07;  author: devrcs;  state: Exp;  lines added/del: 6/2
 * 	sccs rev: 3.7;  orig date: 91/11/07 13:41:58;  orig author: tierney
 * 	        Modified LVM strategy return type to be int for now...
 * 	[91/12/20  10:51:32  William_Burns]
 * 
 * Revision 1.1.3.2  91/11/20  13:53:39  Hal_Project
 * 	Moved from dec/data; pool reorg
 * 	[91/11/18  00:45:28  Donald_Dutile]
 * 
 * Revision 1.1.3.8  92/03/11  09:47:18  cam_proj_Janet_Schank
 * 	"bsubmitted from shared SB"
 * 
 * Revision 1.1.3.7  92/03/02  10:35:46  Janet_Schank
 * 	Fix merge error.
 * 	[92/03/02  10:35:08  Janet_Schank]
 * 
 * Revision 1.1.3.6  92/03/01  17:57:34  cam_proj_Janet_Schank
 * 	Removed references to NSCSI.
 * 	[92/03/01  17:56:49  cam_proj_Janet_Schank]
 * 
 * Revision 1.1.3.5  92/02/27  15:54:35  cam_proj_Janet_Schank
 * 	"bsubmitted from shared SB"
 * 
 * Revision 1.1.3.4  92/02/24  11:43:28  Peter_Keilty
 * 	bmerge against ag.latest
 * 	[92/02/23  13:32:56  Peter_Keilty]
 * 
 * 	Initial checkin of DSA IO subsystem and
 * 	related system files
 * 	[92/02/12  18:35:40  Peter_Keilty]
 * 
 * Revision 1.1.3.3  91/12/20  13:08:35  William_Burns
 * 	revision 3.6.9.2
 * 	date: 91/11/19 13:45:07;  author: devrcs;  state: Exp;  lines added/del: 6/2
 * 	sccs rev: 3.7;  orig date: 91/11/07 13:41:58;  orig author: tierney
 * 	        Modified LVM strategy return type to be int for now...
 * 	[91/12/20  10:51:32  William_Burns]
 * 
 * Revision 1.1.3.2  91/11/20  13:53:39  Hal_Project
 * 	Moved from dec/data; pool reorg
 * 	[91/11/18  00:45:28  Donald_Dutile]
 * 
 * Revision 4.2  91/09/19  23:24:01  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
#ifndef lint
static	char	*sccsid = "@(#)$RCSfile: presto_data.c,v $ $Revision: 1.1.3.12 $ (DEC) $Date: 92/06/29 15:15:01 $";
#endif
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * OSF/1 Release 1.0
 */
/* 
 * derived from presto_data.c	4.2.1.1 (ULTRIX) 4/11/91
 */

/*
 *	Portions of this software have been licensed to 
 *	Digital Equipment Company, Maynard, MA.
 *	Copyright (c) 1990 Legato Systems, Inc.  ALL RIGHTS RESERVED.
 */

/*
 *
 *   Modification history:
 *
 *  04-Nov-91 -- Tom Tierney
 *	Modified LVM strategy return type to be int like all others (one
 *	day all driver entry points that return no value will be "void").
 *
 *  11 Aug 90 -- chet
 *	Re-do data structure allocations; move stuff over from conf.c.
 * 
 *  25 May 90 -- chet
 *	Added this file; it was derived from Legato sources.
 *
 */

#include <sys/prestoioctl.h>

/* Do RZ class disks */
#include "sii.h"
#include "asc.h"
#include "kzq.h"

#if NSII > 0 || NASC > 0 || NKZQ > 0

/*
 * presto - to - SCSI disk driver interface routines
 */

extern int cdisk_open(), cdisk_close(), cdisk_strategy(), cdisk_read(), cdisk_write();
int nulldev();
int RZready();

/*
 * Define presto NVRAM pseudo-driver per-device structures.
 * NOTE:
 *	These data structures are heavily tied to the device major
 *	numbers defined in conf.c; if those change, these must
 *	also change.
 */
#define FIRST_RZ_MAJOR 8

struct prtab RZprtab0 = {
	(dev_t) FIRST_RZ_MAJOR,
	cdisk_strategy,
	RZready,
	NULL
};

/*
 * Is device ready to be opened during presto crash recovery?
 * Presto crash recovery normally happens before we get to single user mode.
 * Some drivers (e.g. shadowing) may want opens deferred until they can
 * get at their configuration data.
 */
int
RZready(dev)
	dev_t dev;
{
	return (1);	/* always ready to be opened */
}

int
RZbopen(dev, flag, fmt)
	dev_t dev;
	int flag, fmt;
{
	return (cdisk_open(dev, flag, fmt));
}

int
RZbclose(dev, flag, fmt)
	dev_t dev;
	int flag, fmt;
{
	extern struct prtab *bprtabs[];

	return (PRclose(dev, flag, fmt, cdisk_close, bprtabs[major(dev)]));
}

RZstrategy(bp)
	struct buf *bp;
{
	extern struct prtab *bprtabs[];

	PRstrategy(bp, cdisk_strategy, bprtabs[major(bp->b_dev)]);
}

int
RZread(dev, uio)
	dev_t dev;
	struct uio *uio;
{
	extern struct prtab *cprtabs[];

	return (PRread(dev, uio, cdisk_read, cprtabs[major(dev)]));
}

int
RZwrite(dev, uio)
	dev_t dev;
	struct uio *uio;
{
	extern struct prtab *cprtabs[];

	return (PRwrite(dev, uio, cdisk_write, cprtabs[major(dev)]));
}
#endif /* NSII > 0 || NASC > 0 || NKZQ > 0 */


/* Do UQ class disks */
#include "uq.h"
#include "ci.h"
#include "bvpssp.h"
#include "msi.h"

#if NCI>0 || NBVPSSP >0 || NUQ >0 || NMSI > 0

/*
 * presto - to - MSCP disk driver interface routines
 */

extern int mscp_strategy(), mscp_read(), mscp_write(),
	mscp_bopen(), mscp_bclose();
int MSCP_ready();

/*
 * Define presto NVRAM pseudo-driver per-device structures.
 * NOTE:
 *	These data structures are heavily tied to the device major
 *	numbers defined in conf.c; if those change, these must
 *	also change.
 */
#define FIRST_UQ_MAJOR 23

struct prtab UQprtab0 = {
	(dev_t) FIRST_UQ_MAJOR,
	mscp_strategy,
	MSCP_ready,
	NULL
};

/*
 * Is device ready to be opened during presto crash recovery?
 * Presto crash recovery normally happens before we get to single user mode.
 * Some drivers (e.g. shadowing) may want opens deferred until they can
 * get at their configuration data.
 */
int
MSCP_ready(dev)
	dev_t dev;
{
	return (1);	/* always ready to be opened */
}

int
MSCP_bopen(dev, flag, fmt)
	dev_t dev;
	int flag, fmt;
{
	return (mscp_bopen(dev, flag, fmt));
}

int
MSCP_bclose(dev, flag, fmt)
	dev_t dev;
	int flag, fmt;
{
	extern struct prtab *bprtabs[];

	return (PRclose(dev, flag, fmt, mscp_bclose, bprtabs[major(dev)]));
}

MSCP_strategy(bp)
	struct buf *bp;
{
	extern struct prtab *bprtabs[];

	PRstrategy(bp, mscp_strategy, bprtabs[major(bp->b_dev)]);
}

int
MSCP_read(dev, uio)
	dev_t dev;
	struct uio *uio;
{
	extern struct prtab *cprtabs[];

	return (PRread(dev, uio, mscp_read, cprtabs[major(dev)]));
}

int
MSCP_write(dev, uio)
	dev_t dev;
	struct uio *uio;
{
	extern struct prtab *cprtabs[];

	return (PRwrite(dev, uio, mscp_write, cprtabs[major(dev)]));
}

#endif /* NCI>0 || NBVPSSP >0 || NUQ >0 || NMSI > 0 */


/* LVM logical devices */

#include <lv.h>

#if NLV > 0

/* Logical Volume Manager - cmajor and bmajor must match */

/* define Presto-to-LVM interface routines */
#include <lvm/lvmd.h>
extern int	lv_open(), lv_close();
extern int	lv_strategy();
extern int	lv_read(), lv_write();
extern int	lv_ready();

/* define presto NVRAM psuedo-driver per-device structures.
 * NOTE:
 *	These data structures are heavily tied to the device major
 *	numbers defined in conf.c;  if those change, these must
 *	also change.
 */

#define FIRST_LVM_MAJOR	16

struct prtab LVMprtab0 = {
    (dev_t) FIRST_LVM_MAJOR,
    lv_strategy,
    lv_ready,
    NULL
};

int
lv_open0(dev, flag, fmt)
    dev_t dev;
    int flag, fmt;
{
    return (lv_open(dev, flag, fmt));
}

int
lv_close0(dev, flag, fmt)
    dev_t dev;
    int flag, fmt;
{
    extern struct prtab *bprtabs[];
    return (PRclose(dev, flag, fmt, lv_close, bprtabs[major(dev)]));
}

lv_strategy0(bp)
    struct buf *bp;
{
    extern struct prtab *bprtabs[];
    PRstrategy(bp, lv_strategy, bprtabs[major(bp->b_dev)]);
}

int
lv_read0(dev, uio)
    dev_t dev;
    struct uio *uio;
{
    extern struct prtab *cprtabs[];
    return (PRread(dev, uio, lv_read, cprtabs[major(dev)]));
}

int
lv_write0(dev, uio)
    dev_t dev;
    struct uio *uio;
{
    extern struct prtab *cprtabs[];
    return (PRwrite(dev, uio, lv_write, cprtabs[major(dev)]));
}

#endif /* NLV > 0 */

#if NLV > 1

#define SECOND_LVM_MAJOR	19

struct prtab LVMprtab1 = {
    (dev_t) SECOND_LVM_MAJOR,
    lv_strategy,
    lv_ready,
    NULL
};

int
lv_open1(dev, flag, fmt)
    dev_t dev;
    int flag, fmt;
{
    return (lv_open(dev, flag, fmt));
}

int
lv_close1(dev, flag, fmt)
    dev_t dev;
    int flag, fmt;
{
    extern struct prtab *bprtabs[];
    return (PRclose(dev, flag, fmt, lv_close, bprtabs[major(dev)]));
}

lv_strategy1(bp)
    struct buf *bp;
{
    extern struct prtab *bprtabs[];
    PRstrategy(bp, lv_strategy, bprtabs[major(bp->b_dev)]);
}

int
lv_read1(dev, uio)
    dev_t dev;
    struct uio *uio;
{
    extern struct prtab *cprtabs[];
    return (PRread(dev, uio, lv_read, cprtabs[major(dev)]));
}

int
lv_write1(dev, uio)
    dev_t dev;
    struct uio *uio;
{
    extern struct prtab *cprtabs[];
    return (PRwrite(dev, uio, lv_write, cprtabs[major(dev)]));
}

#endif /* NLV > 1 */

#if NLV > 2

#define THIRD_LVM_MAJOR	20

struct prtab LVMprtab2 = {
    (dev_t) THIRD_LVM_MAJOR,
    lv_strategy,
    lv_ready,
    NULL
};

int
lv_open2(dev, flag, fmt)
    dev_t dev;
    int flag, fmt;
{
    return (lv_open(dev, flag, fmt));
}

int
lv_close2(dev, flag, fmt)
    dev_t dev;
    int flag, fmt;
{
    extern struct prtab *bprtabs[];
    return (PRclose(dev, flag, fmt, lv_close, bprtabs[major(dev)]));
}

lv_strategy2(bp)
    struct buf *bp;
{
    extern struct prtab *bprtabs[];
    PRstrategy(bp, lv_strategy, bprtabs[major(bp->b_dev)]);
}

int
lv_read2(dev, uio)
    dev_t dev;
    struct uio *uio;
{
    extern struct prtab *cprtabs[];
    return (PRread(dev, uio, lv_read, cprtabs[major(dev)]));
}

int
lv_write2(dev, uio)
    dev_t dev;
    struct uio *uio;
{
    extern struct prtab *cprtabs[];
    return (PRwrite(dev, uio, lv_write, cprtabs[major(dev)]));
}

#endif /* NLV > 2 */

/*
 * Define presto NVRAM pseudo-driver per-device control array.
 * NOTE:
 *	These data structures are heavily tied to the device major
 *	numbers defined in conf.c; if those change, this must
 *	also change.
 */

struct prtab *bprtabs[] = {
	0,	/*0*/
	0,	/*1*/
	0,	/*2*/
	0,	/*3*/
	0,	/*4*/
	0,	/*5*/
	0,	/*6*/
	0,	/*7*/
#if NSII > 0 || NASC > 0 || NKZQ > 0
	&RZprtab0,	/*8*/	/* first scsi block device (same as char) */
#else
	0,	/*8*/
#endif
	0,	/*9*/
	0,	/*10*/
	0,	/*11*/
	0,	/*12*/
	0,	/*13*/
	0,	/*14*/
	0,	/*15*/
#if NLV > 0
	&LVMprtab0,	/*16*/	/* LVM logical devices -- VG 1 */
#else
	0,	/*16*/
#endif
	0,	/*17*/
	0,	/*18*/
#if NLV > 1
	&LVMprtab1,	/*19*/	/* LVM logical devices -- VG 2 */
#else
	0,	/*19*/
#endif
#if NLV > 2
	&LVMprtab2,	/*20*/	/* LVM logical devices -- VG 3 */
#else
	0,	/*20*/
#endif
	0,	/*21 */
	0,	/*22*/
#if NCI > 0 || NBVPSSP > 0 || NUQ >0 || NMSI > 0
	&UQprtab0,	/*23*/  /* first mscp (uq) block device */
#else
	0,	/*23*/
#endif

};

/* maximum block device major number that can be "prestoized" */
int pr_nprbdev = sizeof (bprtabs) / sizeof (bprtabs[0]) - 1;

struct prtab *cprtabs[] = {
	0,	/*0*/
	0,	/*1*/
	0,	/*2*/
	0,	/*3*/
	0,	/*4*/
	0,	/*5*/
	0,	/*6*/
	0,	/*7*/
#if NSII > 0 || NASC > 0 || NKZQ > 0
	&RZprtab0,	/*8*/	/* first scsi char device (same as block) */
#else
	0,	/*8*/
#endif
	0,	/*9*/
	0,	/*10*/
	0,	/*11*/
	0,	/*12*/
	0,	/*13*/
	0,	/*14*/
	0,	/*15*/
#if NLV > 0
	&LVMprtab0,	/*16*/	/* LVM logical devices -- VG 1 */
#else
	0,	/*16*/
#endif
	0,	/*17*/
	0,	/*18*/
#if NLV > 1
	&LVMprtab1,	/*19*/	/* LVM logical devices -- VG 2 */
#else
	0,	/*19*/
#endif
#if NLV > 2
	&LVMprtab2,	/*20*/	/* LVM logical devices -- VG 3 */
#else
	0,	/*20*/
#endif
	0,	/*21 */
	0,	/*22*/
	0,	/*23*/
	0,	/*24*/
	0,	/*25*/
	0,	/*26*/
	0,	/*27*/
#if NCI > 0 || NBVPSSP > 0 || NUQ > 0 || NMSI > 0
	&UQprtab0,	/*28*/  /* first mscp (uq) raw device */
#else
	0,	/*28*/
#endif

};


/* maximum character device major number that can be "prestoized" */
int pr_nprcdev = sizeof (cprtabs) / sizeof (cprtabs[0]) - 1;

